/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence;

import com.exlibris.repository.persistence.HDvViewerParameter;
import com.exlibris.repository.persistence.HPersistent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

@Entity
public class HDvDeliveryRule
extends HPersistent {
    private static final long serialVersionUID = 4L;
    public static final String MATCH_ALL = "*";
    public static final Long MATCH_ALL_NUM = new Long("-1");
    private String name;
    private String description;
    private Calendar statusDate;
    private Calendar createDate;
    private Calendar updateDate;
    private int ruleOrder = 0;
    private boolean disable = false;
    private String objectType = "*";
    private String application = "*";
    private String owner = "*";
    private String userMode = "*";
    private String customAtt1 = "*";
    private String customAtt2 = "*";
    private String customAtt3 = "*";
    private String entityType = "*";
    private String fileEntityType = "*";
    private String usageType = "*";
    private String preservationType = "*";
    private String mimeType = "*";
    private String fileFormat = "*";
    private String fileExtention = "*";
    private String ip = "*";
    private Long fileSizeHigh = MATCH_ALL_NUM;
    private String viewerPreProcessor = "";
    private String viewerUrl = "";
    private String viewerAppendedParameters = "";
    private String profile;
    private String partitionA = "*";
    private String partitionB = "*";
    private String partitionC = "*";
    private String userNames = "*";
    private List<HDvViewerParameter> parameters = new ArrayList<HDvViewerParameter>();
    private HashMap<String, String> hashParameters = null;

    @Column(nullable=false)
    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    @Column(nullable=false)
    public String getCustomAtt1() {
        return this.customAtt1;
    }

    public void setCustomAtt1(String customAtt1) {
        this.customAtt1 = customAtt1;
    }

    @Column(nullable=false)
    public String getCustomAtt2() {
        return this.customAtt2;
    }

    public void setCustomAtt2(String customAtt2) {
        this.customAtt2 = customAtt2;
    }

    @Column(nullable=false)
    public String getCustomAtt3() {
        return this.customAtt3;
    }

    public void setCustomAtt3(String customAtt3) {
        this.customAtt3 = customAtt3;
    }

    @Column(nullable=false)
    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    @Column(nullable=false)
    public String getFileEntityType() {
        return this.fileEntityType;
    }

    public void setFileEntityType(String fileEntityType) {
        this.fileEntityType = fileEntityType;
        if (this.fileEntityType != null) {
            this.fileEntityType = this.fileEntityType.toUpperCase();
        }
    }

    @Column(nullable=false)
    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
        if (this.entityType != null) {
            this.entityType = this.entityType.toUpperCase();
        }
    }

    @Column(nullable=false)
    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    @Column(nullable=false)
    public String getFileExtention() {
        return this.fileExtention;
    }

    public void setFileExtention(String fileExtention) {
        this.fileExtention = fileExtention;
    }

    @Column(nullable=false)
    public Long getFileSizeHigh() {
        return this.fileSizeHigh;
    }

    public void setFileSizeHigh(Long fileSizeHigh) {
        this.fileSizeHigh = fileSizeHigh;
    }

    @Column(nullable=false)
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Column(nullable=false)
    public int getRuleOrder() {
        return this.ruleOrder;
    }

    public void setRuleOrder(int ruleOrder) {
        this.ruleOrder = ruleOrder;
    }

    @Column(nullable=false)
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @OneToMany(mappedBy="deliveryRule", targetEntity=HDvViewerParameter.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<HDvViewerParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<HDvViewerParameter> parameters) {
        this.parameters = parameters;
    }

    @Column(nullable=false)
    public String getUsageType() {
        return this.usageType;
    }

    public void setUsageType(String usageType) {
        this.usageType = usageType;
        if (this.usageType != null) {
            this.usageType = this.usageType.toUpperCase();
        }
    }

    @Column(nullable=false)
    public String getPreservationType() {
        return this.preservationType;
    }

    public void setPreservationType(String preservationType) {
        this.preservationType = preservationType;
    }

    @Column(nullable=false)
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getViewerUrl() {
        return this.viewerUrl;
    }

    public void setViewerUrl(String viewerUrl) {
        this.viewerUrl = viewerUrl;
    }

    public String getViewerAppendedParameters() {
        return this.viewerAppendedParameters;
    }

    public void setViewerAppendedParameters(String viewerAppendedParameters) {
        this.viewerAppendedParameters = viewerAppendedParameters;
    }

    @Column(nullable=false)
    public String getViewerPreProcessor() {
        return this.viewerPreProcessor;
    }

    public void setViewerPreProcessor(String viewerPreProcessor) {
        this.viewerPreProcessor = viewerPreProcessor;
    }

    @Column(nullable=false)
    public String getUserMode() {
        return this.userMode;
    }

    public void setUserMode(String userMode) {
        this.userMode = userMode;
    }

    @Column(nullable=false)
    public String getPartitionA() {
        return this.partitionA;
    }

    public void setPartitionA(String partitionA) {
        this.partitionA = partitionA;
    }

    @Column(nullable=false)
    public String getPartitionB() {
        return this.partitionB;
    }

    public void setPartitionB(String partitionB) {
        this.partitionB = partitionB;
    }

    @Column(nullable=false)
    public String getPartitionC() {
        return this.partitionC;
    }

    public void setPartitionC(String partitionC) {
        this.partitionC = partitionC;
    }

    @Column(name="object_type", nullable=false)
    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType2) {
        this.objectType = objectType2;
    }

    public void addParameter(HDvViewerParameter param) {
        param.setDeliveryRule(this);
        this.parameters.add(param);
    }

    public void addParameter(String key, String val) {
        HDvViewerParameter param = new HDvViewerParameter();
        param.setKey(key.trim());
        param.setVal(val.trim());
        this.addParameter(param);
    }

    public void removeParameter(String key) {
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                HDvViewerParameter param = this.parameters.get(i);
                String currKey = param.getKey();
                if (key == null || !key.equals(currKey)) continue;
                this.parameters.remove(i);
                break;
            }
        }
    }

    public void removeAllParameters() {
        if (this.parameters != null) {
            for (int i = this.parameters.size(); i > 0; --i) {
                this.parameters.remove(i - 1);
            }
        }
    }

    public void updateParameter(String key, String value) {
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                HDvViewerParameter param = this.parameters.get(i);
                String currKey = param.getKey();
                if (key == null || !key.equals(currKey) || value == null) continue;
                this.parameters.get(i).setVal(value);
                break;
            }
        }
    }

    @Transient
    public String getParametersString() {
        StringBuffer paramsString = new StringBuffer();
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                HDvViewerParameter param = this.parameters.get(i);
                paramsString.append(param.getKey()).append("=").append(param.getVal()).append(";");
            }
        }
        return paramsString.toString();
    }

    @Transient
    public HashMap<String, String> getHashParameters() {
        return this.hashParameters;
    }

    public void setHashParameters(HashMap<String, String> hashParameters) {
        this.hashParameters = hashParameters;
    }

    @Column
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="status_date")
    public Calendar getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Calendar statusDate) {
        this.statusDate = statusDate;
    }

    @Column(name="create_date")
    public Calendar getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Calendar createDate) {
        this.createDate = createDate;
    }

    @Column(name="update_date")
    public Calendar getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Calendar updateDate) {
        this.updateDate = updateDate;
    }

    @Column
    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Column
    public String getUserNames() {
        return this.userNames;
    }

    public void setUserNames(String userIDs) {
        this.userNames = userIDs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.application == null ? 0 : this.application.hashCode());
        result = 31 * result + (this.customAtt1 == null ? 0 : this.customAtt1.hashCode());
        result = 31 * result + (this.customAtt2 == null ? 0 : this.customAtt2.hashCode());
        result = 31 * result + (this.customAtt3 == null ? 0 : this.customAtt3.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.disable ? 1231 : 1237);
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = 31 * result + (this.fileExtention == null ? 0 : this.fileExtention.hashCode());
        result = 31 * result + (this.fileSizeHigh == null ? 0 : this.fileSizeHigh.hashCode());
        result = 31 * result + (this.hashParameters == null ? 0 : this.hashParameters.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.userNames == null ? 0 : this.userNames.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.partitionA == null ? 0 : this.partitionA.hashCode());
        result = 31 * result + (this.partitionB == null ? 0 : this.partitionB.hashCode());
        result = 31 * result + (this.partitionC == null ? 0 : this.partitionC.hashCode());
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        result = 31 * result + this.ruleOrder;
        result = 31 * result + (this.statusDate == null ? 0 : this.statusDate.hashCode());
        result = 31 * result + (this.usageType == null ? 0 : this.usageType.hashCode());
        result = 31 * result + (this.userMode == null ? 0 : this.userMode.hashCode());
        result = 31 * result + (this.viewerPreProcessor == null ? 0 : this.viewerPreProcessor.hashCode());
        result = 31 * result + (this.viewerUrl == null ? 0 : this.viewerUrl.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDvDeliveryRule other = (HDvDeliveryRule)obj;
        if (this.application == null ? other.application != null : !this.application.equals(other.application)) {
            return false;
        }
        if (this.customAtt1 == null ? other.customAtt1 != null : !this.customAtt1.equals(other.customAtt1)) {
            return false;
        }
        if (this.customAtt2 == null ? other.customAtt2 != null : !this.customAtt2.equals(other.customAtt2)) {
            return false;
        }
        if (this.customAtt3 == null ? other.customAtt3 != null : !this.customAtt3.equals(other.customAtt3)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.disable != other.disable) {
            return false;
        }
        if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
            return false;
        }
        if (this.fileExtention == null ? other.fileExtention != null : !this.fileExtention.equals(other.fileExtention)) {
            return false;
        }
        if (this.fileSizeHigh == null ? other.fileSizeHigh != null : !this.fileSizeHigh.equals(other.fileSizeHigh)) {
            return false;
        }
        if (this.hashParameters == null ? other.hashParameters != null : !this.hashParameters.equals(other.hashParameters)) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.objectType == null ? other.objectType != null : !this.objectType.equals(other.objectType)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.userNames == null ? other.userNames != null : !this.userNames.equals(other.userNames)) {
            return false;
        }
        if (this.partitionA == null ? other.partitionA != null : !this.partitionA.equals(other.partitionA)) {
            return false;
        }
        if (this.partitionB == null ? other.partitionB != null : !this.partitionB.equals(other.partitionB)) {
            return false;
        }
        if (this.partitionC == null ? other.partitionC != null : !this.partitionC.equals(other.partitionC)) {
            return false;
        }
        if (this.profile == null ? other.profile != null : !this.profile.equals(other.profile)) {
            return false;
        }
        if (this.ruleOrder != other.ruleOrder) {
            return false;
        }
        if (this.statusDate == null ? other.statusDate != null : !this.statusDate.equals(other.statusDate)) {
            return false;
        }
        if (this.usageType == null ? other.usageType != null : !this.usageType.equals(other.usageType)) {
            return false;
        }
        if (this.userMode == null ? other.userMode != null : !this.userMode.equals(other.userMode)) {
            return false;
        }
        if (this.viewerPreProcessor == null ? other.viewerPreProcessor != null : !this.viewerPreProcessor.equals(other.viewerPreProcessor)) {
            return false;
        }
        return !(this.viewerUrl == null ? other.viewerUrl != null : !this.viewerUrl.equals(other.viewerUrl));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getSimpleName());
        buffer.append("(objectType = ");
        buffer.append(this.getObjectType());
        buffer.append(", entityType = ");
        buffer.append(this.getEntityType());
        buffer.append(", fileEntityType = ");
        buffer.append(this.getFileEntityType());
        buffer.append(", usageType = ");
        buffer.append(this.getUsageType());
        buffer.append(", mimeType = ");
        buffer.append(this.getMimeType());
        buffer.append(", fileExtension = ");
        buffer.append(this.getFileExtention());
        buffer.append(")");
        return buffer.toString();
    }
}

