/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class Base16 {
    public static String encodeTab = "0123456789ABCDEF";
    public static byte[] decodeTab = new byte[256];

    protected Base16() {
    }

    public static String decodeToString(String in) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(256);
        boolean b = true;
        int idx = 0;
        int mod = 0;
        int cout = 0;
        while (b) {
            if (idx < in.length()) {
                char cin;
                byte cIdx;
                if ((cIdx = decodeTab[cin = in.charAt(idx++)]) != -1) {
                    switch (mod) {
                        case 0: {
                            cout = cIdx << 4;
                            break;
                        }
                        case 1: {
                            out.append((char)(cout |= cIdx));
                        }
                    }
                    mod = (mod + 1) % 2;
                    continue;
                }
                return null;
            }
            b = false;
        }
        if (mod != 1) {
            return out.toString();
        }
        return null;
    }

    public static byte[] decodeToArray(String in) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean b = true;
        int idx = 0;
        int mod = 0;
        int cout = 0;
        while (b) {
            if (idx < in.length()) {
                char cin;
                byte cIdx;
                if ((cIdx = decodeTab[cin = in.charAt(idx++)]) != -1) {
                    switch (mod) {
                        case 0: {
                            cout = cIdx << 4;
                            break;
                        }
                        case 1: {
                            out.write(cout |= cIdx);
                        }
                    }
                    mod = (mod + 1) % 2;
                    continue;
                }
                return null;
            }
            b = false;
        }
        if (mod != 1) {
            return out.toByteArray();
        }
        return null;
    }

    public static String encodeString(String in) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(256);
        boolean b = true;
        int idx = 0;
        while (b) {
            if (idx < in.length()) {
                char cin;
                if ((cin = in.charAt(idx++)) < '\u0100') {
                    out.append(encodeTab.charAt(cin >> 4 & 0xF));
                    out.append(encodeTab.charAt(cin & 0xF));
                    continue;
                }
                return null;
            }
            b = false;
        }
        return out.toString();
    }

    public static String encodeArray(byte[] in) {
        if (in == null) {
            return null;
        }
        if (in.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(256);
        boolean b = true;
        int idx = 0;
        while (b) {
            if (idx < in.length) {
                int cin = in[idx++] & 0xFF;
                out.append(encodeTab.charAt(cin >> 4 & 0xF));
                out.append(encodeTab.charAt(cin & 0xF));
                continue;
            }
            b = false;
        }
        return out.toString();
    }

    static {
        Arrays.fill(decodeTab, (byte)-1);
        for (int i = 0; i < encodeTab.length(); ++i) {
            Base16.decodeTab[Character.toUpperCase((char)Base16.encodeTab.charAt((int)i))] = (byte)i;
            Base16.decodeTab[Character.toLowerCase((char)Base16.encodeTab.charAt((int)i))] = (byte)i;
        }
    }
}

