/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MaxLengthRecordingInputStream
extends FilterInputStream {
    public static final int SKIP_READ_BUFFER_SIZE = 1024;
    protected byte[] skip_read_buffer = new byte[1024];
    protected ByteArrayOutputStream record = new ByteArrayOutputStream();
    protected long available;

    public MaxLengthRecordingInputStream(InputStream in, long available) {
        super(in);
        this.available = available;
    }

    public byte[] getRecording() {
        return this.record.toByteArray();
    }

    @Override
    public void close() throws IOException {
        this.record.close();
    }

    @Override
    public int available() throws IOException {
        return this.available > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.available;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        int b = -1;
        if (this.available > 0L && (b = this.in.read()) != -1) {
            --this.available;
            this.record.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = -1;
        if (this.available > 0L && (bytesRead = this.in.read(b, off, (int)Math.min((long)len, this.available))) > 0) {
            this.available -= (long)bytesRead;
            this.record.write(b, off, bytesRead);
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = 0L;
        if (this.available > 0L && (bytesSkipped = (long)this.read(this.skip_read_buffer, 0, (int)Math.min(Math.min(n, this.available), 1024L))) == -1L) {
            bytesSkipped = 0L;
        }
        return bytesSkipped;
    }
}

