/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.archive.common;

import java.io.IOException;
import java.util.Arrays;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Scheme;

public class ReaderFactoryAbstract {
    protected static final int GZIP_MAGIC = 35615;
    protected static final String ARC_MAGIC_HEADER = "filedesc:";
    protected static final String WARC_MAGIC_HEADER = "WARC/";

    protected ReaderFactoryAbstract() {
    }

    public static boolean isGzipped(ByteCountingPushBackInputStream pbin) throws IOException {
        if (pbin == null) {
            throw new IllegalArgumentException("'pbin'is null!");
        }
        byte[] magicBytes = new byte[2];
        int magicNumber = -559038737;
        int read = pbin.readFully(magicBytes);
        if (read == 2) {
            magicNumber = (magicBytes[1] & 0xFF) << 8 | magicBytes[0] & 0xFF;
        }
        if (read > 0) {
            pbin.unread(magicBytes, 0, read);
        }
        return magicNumber == 35615;
    }

    public static boolean isArcFile(ByteCountingPushBackInputStream pbin) throws IOException {
        byte[] streamBytes = new byte[ARC_MAGIC_HEADER.length()];
        byte[] arcBytes = ARC_MAGIC_HEADER.getBytes();
        pbin.peek(streamBytes);
        return Arrays.equals(arcBytes, streamBytes);
    }

    public static boolean isArcRecord(ByteCountingPushBackInputStream pbin) throws IOException {
        byte[] streamBytes = new byte[32];
        pbin.peek(streamBytes);
        return Scheme.startsWithScheme(streamBytes);
    }

    public static boolean isWarcFile(ByteCountingPushBackInputStream pbin) throws IOException {
        return ReaderFactoryAbstract.isWarcRecord(pbin);
    }

    public static boolean isWarcRecord(ByteCountingPushBackInputStream pbin) throws IOException {
        byte[] streamBytes = new byte[WARC_MAGIC_HEADER.length()];
        byte[] warcBytes = WARC_MAGIC_HEADER.getBytes();
        pbin.peek(streamBytes);
        return Arrays.equals(warcBytes, streamBytes);
    }
}

