/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    protected RandomAccessFile raf;
    protected long mark_position = -1L;

    public RandomAccessFileInputStream(RandomAccessFile raf) {
        this.raf = raf;
    }

    @Override
    public void close() throws IOException {
        this.raf = null;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark_position = this.raf.getFilePointer();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark_position == -1L) {
            throw new IOException("Mark not set or is invalid");
        }
        this.raf.seek(this.mark_position);
    }

    @Override
    public int available() throws IOException {
        long avail = this.raf.length() - this.raf.getFilePointer();
        return (int)Math.min(avail, Integer.MAX_VALUE);
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = Math.min(n, this.raf.length() - this.raf.getFilePointer());
        this.raf.seek(this.raf.getFilePointer() + skip);
        return skip;
    }

    @Override
    public int read() throws IOException {
        return this.raf.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raf.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }
}

