/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.ech0160v11;

import ch.docuteam.mapping.ech0160v11.Ablieferung;
import ch.docuteam.mapping.ech0160v11.Datei;
import ch.docuteam.mapping.ech0160v11.Dokument;
import ch.docuteam.mapping.ech0160v11.Dossier;
import ch.docuteam.mapping.ech0160v11.InvalidMappingException;
import ch.docuteam.mapping.ech0160v11.LevelType;
import ch.docuteam.mapping.ech0160v11.Mapping;
import ch.docuteam.mapping.ech0160v11.MetadataXML;
import ch.docuteam.mapping.ech0160v11.Ordnungssystem;
import ch.docuteam.mapping.ech0160v11.Ordnungssystemposition;
import ch.docuteam.mapping.ech0160v11.Paket;
import ch.docuteam.mapping.ech0160v11.Provenienz;
import ch.docuteam.tools.file.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class MappingAdapter {
    private static final String CONTEXT_PATH_MAPPING = "ch.docuteam.mapping.ech0160v11";
    private Mapping mapping;
    private String saId;
    private String dssId;
    private boolean outputSIPUnzipped = true;
    private boolean ignoreEmptyElement = false;
    private MetadataXML metadataXML;
    private Map<ECH_LEVELS, LevelType> levelMap;

    public MappingAdapter(String mappingFilePath) throws InvalidMappingException {
        try (InputStream mappingFileInputStream = ResourceUtil.getResourceAsStream((String)mappingFilePath);){
            this.mapping = this.getMappingConfiguration(mappingFileInputStream);
            this.saId = this.mapping.getSubmissionAgreement().getID();
            this.dssId = this.mapping.getSubmissionAgreement().getDssId();
            if (this.mapping.getOutputSIP() != null) {
                this.outputSIPUnzipped = this.mapping.getOutputSIP().isUnzipped();
            }
            if (this.mapping.getIgnoreEmptyElement() != null) {
                this.ignoreEmptyElement = this.mapping.getIgnoreEmptyElement().isIgnore();
            }
            if (this.mapping.getMetadataXML() != null) {
                this.metadataXML = this.mapping.getMetadataXML();
            }
            this.levelMap = this.getMappedLevels(this.mapping);
        }
        catch (IOException e) {
            throw new InvalidMappingException("mapping file not found at: " + mappingFilePath);
        }
    }

    Mapping getMapping() {
        return this.mapping;
    }

    String getSaId() {
        return this.saId;
    }

    String getDssId() {
        return this.dssId;
    }

    boolean isOutputSIPUnzipped() {
        return this.outputSIPUnzipped;
    }

    void setOutputSIPUnzipped(boolean outputSIPUnzipped) {
        this.outputSIPUnzipped = outputSIPUnzipped;
    }

    boolean isIgnoreEmptyElement() {
        return this.ignoreEmptyElement;
    }

    void setIgnoreEmptyElement(boolean ignoreEmptyElement) {
        this.ignoreEmptyElement = ignoreEmptyElement;
    }

    MetadataXML getMetadataXML() {
        return this.metadataXML;
    }

    private Mapping getMappingConfiguration(InputStream mappingFileInputStream) throws InvalidMappingException {
        if (mappingFileInputStream != null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)CONTEXT_PATH_MAPPING);
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                Mapping mapping = (Mapping)jaxbUnmarshaller.unmarshal(mappingFileInputStream);
                return mapping;
            }
            catch (JAXBException e) {
                throw new InvalidMappingException("cannot unmarshall mapping object due to: ", e);
            }
        }
        throw new InvalidMappingException("cannot find mapping file at: " + mappingFileInputStream);
    }

    private Map<ECH_LEVELS, LevelType> getMappedLevels(Mapping mapping) throws InvalidMappingException {
        this.levelMap = new HashMap<ECH_LEVELS, LevelType>();
        List<LevelType> levels = mapping.getLevel();
        for (LevelType level : levels) {
            if (level instanceof Paket) {
                this.levelMap.put(ECH_LEVELS.Paket, level);
                continue;
            }
            if (level instanceof Ablieferung) {
                this.levelMap.put(ECH_LEVELS.Ablieferung, level);
                continue;
            }
            if (level instanceof Ordnungssystem) {
                this.levelMap.put(ECH_LEVELS.Ordnungssytem, level);
                continue;
            }
            if (level instanceof Ordnungssystemposition) {
                this.levelMap.put(ECH_LEVELS.Ordnungssytemposition, level);
                continue;
            }
            if (level instanceof Dossier) {
                this.levelMap.put(ECH_LEVELS.Dossier, level);
                continue;
            }
            if (level instanceof Dokument) {
                this.levelMap.put(ECH_LEVELS.Dokument, level);
                continue;
            }
            if (level instanceof Datei) {
                this.levelMap.put(ECH_LEVELS.Datei, level);
                continue;
            }
            if (level instanceof Provenienz) {
                this.levelMap.put(ECH_LEVELS.Provenienz, level);
                continue;
            }
            throw new InvalidMappingException("unknown level: " + level);
        }
        if (this.levelMap.get((Object)ECH_LEVELS.Paket) == null) {
            throw new InvalidMappingException("missing mapping for Paket");
        }
        return this.levelMap;
    }

    Map<ECH_LEVELS, LevelType> getMappedLevels() {
        return this.levelMap;
    }

    static enum ECH_LEVELS {
        Paket,
        Ablieferung,
        Ordnungssytem,
        Ordnungssytemposition,
        Dossier,
        Dokument,
        Datei,
        Provenienz;

    }
}

