/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.edidoc;

import ch.docuteam.mapping.edidoc.ContentXML;
import ch.docuteam.mapping.edidoc.InvalidMappingException;
import ch.docuteam.mapping.edidoc.KeyValueEntry;
import ch.docuteam.mapping.edidoc.LevelType;
import ch.docuteam.mapping.edidoc.Mapping;
import ch.docuteam.mapping.edidoc.MatterhornFieldType;
import ch.docuteam.mapping.edidoc.XpathMapper;
import ch.docuteam.tools.file.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class MappingAdapter {
    private static final String CONTEXT_PATH_MAPPING = "ch.docuteam.mapping.edidoc";
    private final String saId;
    private final String dssId;
    private final Map<String, MatterhornFieldType> keyValueMap;
    private final Map<String, XpathMapper> xpathMapperMap;
    private boolean outputSIPUnzipped = true;
    private ContentXML contentXML;
    private boolean useSteuerXml = false;
    private final Map<String, LevelType> levelMap;

    public MappingAdapter(String mappingFilePath) {
        try (InputStream mappingFileInputStream = ResourceUtil.getResourceAsStream((String)mappingFilePath);){
            Mapping mapping = this.getMappingConfiguration(mappingFileInputStream);
            this.saId = mapping.getSubmissionAgreement().getID();
            this.dssId = mapping.getSubmissionAgreement().getDssId();
            if (mapping.getOutputSIP() != null) {
                this.outputSIPUnzipped = mapping.getOutputSIP().isUnzipped();
            }
            if (mapping.getSteuerXML() != null) {
                this.useSteuerXml = mapping.getSteuerXML().isUseSteuerXML();
            }
            if (mapping.getContentXML() != null) {
                this.contentXML = mapping.getContentXML();
            }
            this.levelMap = this.getMappedLevels(mapping);
            this.keyValueMap = this.getKeyValueMapping(mapping);
            this.xpathMapperMap = this.getXpathMapperMap(mapping);
        }
        catch (IOException e) {
            throw new InvalidMappingException("mapping file not found at: " + mappingFilePath);
        }
    }

    private Mapping getMappingConfiguration(InputStream mappingFileInputStream) throws InvalidMappingException {
        if (mappingFileInputStream != null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)CONTEXT_PATH_MAPPING);
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                return (Mapping)jaxbUnmarshaller.unmarshal(mappingFileInputStream);
            }
            catch (JAXBException e) {
                throw new InvalidMappingException("cannot unmarshall mapping object due to: ", e);
            }
        }
        throw new InvalidMappingException("cannot find mapping file at: " + mappingFileInputStream);
    }

    private Map<String, LevelType> getMappedLevels(Mapping mapping) {
        return mapping.getLevel().stream().collect(Collectors.toUnmodifiableMap(LevelType::getJavaClass, Function.identity()));
    }

    private Map<String, MatterhornFieldType> getKeyValueMapping(Mapping mapping) {
        return mapping.getKeyValueMapping() == null ? Map.of() : mapping.getKeyValueMapping().getKeyValueEntry().stream().collect(Collectors.toUnmodifiableMap(KeyValueEntry::getKey, KeyValueEntry::getMatterhorn));
    }

    private Map<String, XpathMapper> getXpathMapperMap(Mapping mapping) {
        return mapping == null ? Map.of() : mapping.getXpathMapper().stream().collect(Collectors.toUnmodifiableMap(XpathMapper::getId, Function.identity()));
    }

    String getSaId() {
        return this.saId;
    }

    String getDssId() {
        return this.dssId;
    }

    boolean isOutputSIPUnzipped() {
        return this.outputSIPUnzipped;
    }

    boolean isUseSteuerXml() {
        return this.useSteuerXml;
    }

    ContentXML getContentXML() {
        return this.contentXML;
    }

    Map<String, LevelType> getMappedLevels() {
        return this.levelMap;
    }

    public XpathMapper getXpathMapper(String mapperId) {
        return this.xpathMapperMap.get(mapperId);
    }

    public Map<String, MatterhornFieldType> getKeyValueMap() {
        return this.keyValueMap;
    }
}

