/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.util;

import ch.docuteam.mapping.util.UnmarshalException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlUtil {
    public static <T> T unmarshalXml(Path pathToFile, Class<T> targetClass) {
        try {
            XMLStreamReader metadataFile = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(pathToFile.toFile()));
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{targetClass});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement jaxbElement = jaxbUnmarshaller.unmarshal(metadataFile, targetClass);
            return (T)jaxbElement.getValue();
        }
        catch (FileNotFoundException | JAXBException | XMLStreamException e) {
            throw new UnmarshalException(String.format("Cannot unmarshal xml file '%s'", pathToFile), e);
        }
    }
}

