/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file.exception;

import java.util.List;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;

public class DROIDMultipleIdentificationsFoundException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final List<IdentificationResult> resultList;

    public DROIDMultipleIdentificationsFoundException(String filePath, List<IdentificationResult> resultList) {
        super(filePath);
        this.resultList = resultList;
    }

    public List<IdentificationResult> getResultList() {
        return this.resultList;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder(super.getMessage());
        for (IdentificationResult r : this.resultList) {
            message.append("\npuid='").append(r.getPuid()).append("' name='").append(r.getName()).append("' ver='").append(r.getVersion()).append("' mime='").append(r.getMimeType()).append("' method='").append(r.getMethod()).append("'");
        }
        return message.toString();
    }
}

