/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.ldap;

import ch.docuteam.tools.out.Logger;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public abstract class LDAPClient {
    private static final String ContextFactoryClassName = "com.sun.jndi.ldap.LdapCtxFactory";
    private static String LDAPUrl;
    private static String SecurityPrincipal;
    private static String SecurityCredentials;
    private static DirContext LDAPContext;

    public static void main(String[] args) throws Exception {
        LDAPClient.open(args[0], args[1], args[2]);
        Logger.info(LDAPClient.retrieveFieldValueOfFirstHit(args[3], args[4], "cn"));
        Logger.info(LDAPClient.retrieveFieldValueOfFirstHit(args[3], args[4], "department"));
        Logger.info(LDAPClient.retrieveFieldValueOfFirstHit(args[3], args[4], "mail"));
    }

    public static DirContext open(String ldapurl) throws NamingException {
        LDAPUrl = ldapurl;
        return LDAPClient.open();
    }

    public static DirContext open(String ldapurl, String username, String password) throws NamingException {
        LDAPUrl = ldapurl;
        SecurityPrincipal = username;
        SecurityCredentials = password;
        return LDAPClient.open();
    }

    public static String retrieveFieldValueOfFirstHit(String baseDN, String filter, String field) throws NamingException {
        NamingEnumeration<SearchResult> results = LDAPClient.retrieve(baseDN, filter);
        if (results == null) {
            throw new NullPointerException();
        }
        return field + ": " + (String)results.next().getAttributes().get(field).get();
    }

    public static NamingEnumeration<SearchResult> retrieve(String baseDN) throws NamingException {
        return LDAPClient.retrieve(baseDN, "(cn=*)");
    }

    public static NamingEnumeration<SearchResult> retrieve(String baseDN, String filter) throws NamingException {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningObjFlag(true);
        NamingEnumeration<SearchResult> results = null;
        results = LDAPContext.search(baseDN, filter, controls);
        return results;
    }

    public static void close() throws NamingException {
        Logger.debug("Closing");
        if (LDAPContext != null) {
            LDAPContext.close();
        }
    }

    public static void systemOut(NamingEnumeration<SearchResult> results) throws NamingException {
        if (results == null) {
            return;
        }
        while (results.hasMore()) {
            SearchResult searchResult = results.next();
            LDAPClient.systemOut(searchResult);
        }
    }

    public static void systemOut(SearchResult searchResult) throws NamingException {
        NamingEnumeration<? extends Attribute> attributes = searchResult.getAttributes().getAll();
        while (attributes.hasMore()) {
            Attribute attribute = attributes.next();
            StringBuffer s = new StringBuffer(attribute.getID() + ": ");
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMore()) {
                s.append(" " + (String)values.next());
            }
            Logger.info(s.toString());
        }
        Logger.info("----------");
    }

    private static DirContext open() throws NamingException {
        Logger.debug("Creating LDAP Connection: " + LDAPUrl);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", ContextFactoryClassName);
        env.put("java.naming.provider.url", LDAPUrl);
        if (SecurityPrincipal != null) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", SecurityPrincipal);
            env.put("java.naming.security.credentials", SecurityCredentials);
        }
        LDAPContext = new InitialDirContext(env);
        return LDAPContext;
    }
}

