/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.os;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public abstract class SystemClipboard {
    private static ClipboardOwnerImpl Clipboard = new ClipboardOwnerImpl();

    public static void setText(String string) {
        Clipboard.setClipboardContents(string);
    }

    public static String getText() {
        return Clipboard.getClipboardContents();
    }

    private static class ClipboardOwnerImpl
    implements ClipboardOwner {
        private ClipboardOwnerImpl() {
        }

        public void setClipboardContents(String aString) {
            StringSelection stringSelection = new StringSelection(aString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, this);
        }

        public String getClipboardContents() {
            String result = "";
            Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    result = (String)contents.getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
        }
    }
}

