/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;

public class XSLStylesheet
extends XSLModuleRoot {
    @Override
    protected boolean mayContainParam() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        this.processDefaultCollationAttribute();
        this.processDefaultMode();
        String inputTypeAnnotationsAtt = null;
        AttributeCollection atts = this.getAttributeList();
        block24: for (int a = 0; a < atts.getLength(); ++a) {
            String f;
            switch (f = atts.getQName(a)) {
                case "version": {
                    continue block24;
                }
                case "id": {
                    continue block24;
                }
                case "extension-element-prefixes": {
                    continue block24;
                }
                case "exclude-result-prefixes": {
                    continue block24;
                }
                case "input-type-annotations": {
                    inputTypeAnnotationsAtt = atts.getValue(a);
                    continue block24;
                }
                default: {
                    this.checkUnknownAttribute(atts.getNodeName(a));
                }
            }
        }
        if (this.version == -1 && (this.getParent() == null || this.getParent().getNodeKind() == 9)) {
            this.reportAbsence("version");
        }
        if (inputTypeAnnotationsAtt != null) {
            switch (inputTypeAnnotationsAtt) {
                case "strip": {
                    break;
                }
                case "preserve": {
                    break;
                }
                case "unspecified": {
                    break;
                }
                default: {
                    this.invalidAttribute("input-type-annotations", "strip|preserve|unspecified");
                }
            }
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo curr;
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (this.getParent() != null && this.getParent().getNodeKind() != 9) {
            this.compileError(this.getDisplayName() + " must be the outermost element", "XTSE0010");
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = kids.next()) != null) {
            if (curr.getNodeKind() == 3 || curr instanceof StyleElement && ((StyleElement)curr).isDeclaration() || curr instanceof DataElement || !"http://www.w3.org/1999/XSL/Transform".equals(curr.getURI()) && !"".equals(curr.getURI()) || curr instanceof AbsentExtensionElement && ((StyleElement)curr).forwardsCompatibleModeIsEnabled()) continue;
            if ("http://www.w3.org/1999/XSL/Transform".equals(curr.getURI())) {
                assert (curr instanceof StyleElement);
                ((StyleElement)curr).compileError("Element " + curr.getDisplayName() + " must not appear directly within " + this.getDisplayName(), "XTSE0010");
                continue;
            }
            assert (curr instanceof StyleElement);
            ((StyleElement)curr).compileError("Element " + curr.getDisplayName() + " must not appear directly within " + this.getDisplayName() + " because it is not in a namespace", "XTSE0130");
        }
    }
}

