/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.net.InetAddress;
import java.util.Date;
import org.jwat.arc.ArcDateParser;
import org.jwat.common.ContentType;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.IPAddressParser;
import org.jwat.common.Uri;
import org.jwat.common.UriProfile;

public class ArcFieldParsers {
    protected Diagnostics<Diagnosis> diagnostics;

    protected void addInvalidExpectedError(String entity, String ... information) {
        this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_EXPECTED, entity, information));
    }

    protected void addRequiredMissingError(String entity) {
        this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.REQUIRED_MISSING, entity, new String[0]));
    }

    protected String parseString(String str, String field, boolean nullable) {
        if (!(nullable || str != null && str.trim().length() != 0)) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return str;
    }

    protected Integer parseInteger(String intStr, String field, boolean nullable) {
        Integer iVal = null;
        if (intStr != null && intStr.length() > 0) {
            try {
                iVal = Integer.valueOf(intStr);
            }
            catch (Exception e) {
                this.addInvalidExpectedError("'" + field + "' value", intStr, "Numeric format");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return iVal;
    }

    protected Long parseLong(String longStr, String field, boolean nullable) {
        Long lVal = null;
        if (longStr != null && longStr.length() > 0) {
            try {
                lVal = Long.valueOf(longStr);
            }
            catch (Exception e) {
                this.addInvalidExpectedError("'" + field + "' value", longStr, "Numeric format");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return lVal;
    }

    protected ContentType parseContentType(String contentTypeStr, String field, boolean nullable) {
        ContentType contentType = null;
        if (contentTypeStr != null && contentTypeStr.length() != 0) {
            contentType = ContentType.parseContentType((String)contentTypeStr);
            if (contentType == null) {
                this.addInvalidExpectedError("'" + field + "' value", contentTypeStr, "<type>/<sub-type>(; <argument>=<value>)*");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return contentType;
    }

    protected InetAddress parseIpAddress(String ipAddress, String field, boolean nullable) {
        InetAddress inetAddr = null;
        if (ipAddress != null && ipAddress.length() > 0) {
            inetAddr = IPAddressParser.getAddress((String)ipAddress);
            if (inetAddr == null) {
                this.addInvalidExpectedError("'" + field + "' value", ipAddress, "IPv4 or IPv6 format");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return inetAddr;
    }

    protected Uri parseUri(String uriStr, UriProfile uriProfile, String field, boolean nullable) {
        Uri uri = null;
        if (uriStr != null && uriStr.length() != 0) {
            try {
                uri = new Uri(uriStr, uriProfile);
            }
            catch (Exception e) {
                this.addInvalidExpectedError("'" + field + "' value", uriStr, e.getMessage());
            }
            if (uri != null) {
                String scheme = uri.getScheme();
                if (scheme == null) {
                    uri = null;
                    this.addInvalidExpectedError("'" + field + "' value", uriStr, "Absolute URI");
                } else {
                    scheme = scheme.toLowerCase();
                }
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return uri;
    }

    protected Date parseDate(String dateStr, String field, boolean nullable) {
        Date date = null;
        if (dateStr != null && dateStr.length() > 0) {
            date = ArcDateParser.getDate(dateStr);
            if (date == null) {
                this.addInvalidExpectedError("'" + field + "' value", dateStr, "yyyyMMddHHmmss");
            }
        } else if (!nullable) {
            this.addRequiredMissingError("'" + field + "' value");
        }
        return date;
    }
}

