/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jwat.arc.ArcFileNaming;

public class ArcFileNamingDefault
implements ArcFileNaming {
    protected DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected String filePrefix;
    protected Date date;
    protected String dateStr;
    protected String hostname;
    protected String extension;

    public ArcFileNamingDefault(String filePrefix, Date date, String hostname, String extension) {
        this.filePrefix = filePrefix != null ? filePrefix : "JWAT";
        this.date = date != null ? date : new Date();
        if (hostname != null) {
            this.hostname = hostname;
        } else {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName().toLowerCase();
            }
            catch (UnknownHostException e) {
                this.hostname = "unknown";
            }
        }
        this.extension = extension != null ? extension : ".arc";
        this.dateStr = this.dateFormat.format(this.date);
    }

    @Override
    public boolean supportMultipleFiles() {
        return true;
    }

    @Override
    public String getFilename(int sequenceNr, boolean bCompressed) {
        String filename = this.filePrefix + "-" + this.dateStr + "-" + String.format("%05d", sequenceNr++) + "-" + this.hostname + this.extension;
        if (bCompressed) {
            filename = filename + ".gz";
        }
        return filename;
    }
}

