/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.gui.MultiLineLabel;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CopySIPDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected JTextField copyNameTextField;
    protected JCheckBox beZIPCheckBox;
    protected JButton goButton;
    protected boolean goButtonWasClicked = false;

    protected static String open(LauncherView owner, String message, String title, String textFieldContent) {
        CopySIPDialog dialog = new CopySIPDialog(owner, message, title, textFieldContent);
        if (!dialog.goButtonWasClicked) {
            return null;
        }
        Object name = dialog.copyNameTextField.getText();
        if (dialog.beZIPCheckBox.isSelected()) {
            if (!((String)name).toLowerCase().endsWith(".zip")) {
                name = (String)name + ".zip";
            }
        } else if (((String)name).toLowerCase().endsWith(".zip")) {
            name = FileUtil.asFilePathWithoutExtension((String)name);
        }
        return name;
    }

    private CopySIPDialog(LauncherView owner, String message, String title, String textFieldContent) {
        super(owner, title, true);
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.setDefaultCloseOperation(2);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CopySIPDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.copyNameTextField = new JTextField(textFieldContent);
        this.copyNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopySIPDialog.this.goButtonWasClicked();
            }
        });
        this.beZIPCheckBox = new JCheckBox("ZIP", owner.isNewSIPZippedByDefault());
        this.beZIPCheckBox.setToolTipText(I18N.translate((String)"ToolTipBeZIP"));
        this.goButton = new JButton(PackerConstants.getImageIcon("Save.png"));
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopySIPDialog.this.goButtonWasClicked();
            }
        });
        new JLabel(PackerConstants.getImageIcon("DocuteamPacker.png"));
        GridBagPanel gridBag = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(0, 5, 0, 5));
        gridBag.add((Component)new JLabel(PackerConstants.getImageIcon("DocuteamPacker.png")), 0, 2, 0, 0, 10);
        gridBag.add((Component)new MultiLineLabel(message, 0.0f), 1, 1, 17);
        gridBag.add((Component)this.copyNameTextField, 2, 1, 17, 2, 1.0, 0.0);
        gridBag.add((Component)this.beZIPCheckBox, 2, 2);
        gridBag.add((Component)this.goButton, 3, 2, 13);
        this.add((Component)gridBag);
        this.setPreferredSize(new Dimension(450, 150));
        this.pack();
        this.setLocationRelativeTo(owner);
        this.copyNameTextField.requestFocusInWindow();
        this.setVisible(true);
    }

    private void goButtonWasClicked() {
        this.goButtonWasClicked = true;
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }
}

