/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.tableModel;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.tools.translations.I18N;
import javax.swing.table.AbstractTableModel;

public class FileDataViewTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private NodeAbstract fileStructureNode;

    public void setFileStructureNode(NodeAbstract fileStructureNode) {
        this.fileStructureNode = fileStructureNode;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return 13;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            switch (rowIndex) {
                case 0: {
                    return I18N.translate((String)"HeaderName");
                }
                case 1: {
                    return I18N.translate((String)"HeaderPropertiesPath");
                }
                case 2: {
                    return I18N.translate((String)"HeaderType");
                }
                case 3: {
                    return I18N.translate((String)"HeaderPropertiesMIMEType");
                }
                case 4: {
                    return I18N.translate((String)"HeaderPropertiesFormat");
                }
                case 5: {
                    return I18N.translate((String)"HeaderPropertiesFormatKey");
                }
                case 6: {
                    return I18N.translate((String)"HeaderPropertiesSizeKB");
                }
                case 7: {
                    return I18N.translate((String)"HeaderPropertiesSize%");
                }
                case 8: {
                    return I18N.translate((String)"HeaderPropertiesChildren");
                }
                case 9: {
                    return I18N.translate((String)"HeaderPropertiesDescendants");
                }
                case 10: {
                    return I18N.translate((String)"HeaderPropertiesEvents");
                }
                case 11: {
                    return I18N.translate((String)"HeaderPropertiesSubmitStatus");
                }
                case 12: {
                    return I18N.translate((String)"HeaderPropertiesPreservationRole");
                }
            }
        } else if (columnIndex == 1) {
            if (this.fileStructureNode == null) {
                return null;
            }
            switch (rowIndex) {
                case 0: {
                    return this.fileStructureNode.getLabel();
                }
                case 1: {
                    return this.fileStructureNode.getPathString();
                }
                case 2: {
                    return this.fileStructureNode.getType();
                }
                case 3: {
                    return this.fileStructureNode.getMimeType();
                }
                case 4: {
                    return this.fileStructureNode.getFormatName();
                }
                case 5: {
                    return this.fileStructureNode.getFormatKey();
                }
                case 6: {
                    return Long.valueOf(this.fileStructureNode.getSize() / 1024L).toString();
                }
                case 7: {
                    return this.fileStructureNode.getRelativeSize().toString();
                }
                case 8: {
                    return this.fileStructureNode.isFile() ? "-" : Integer.valueOf(this.fileStructureNode.getChildCount());
                }
                case 9: {
                    return this.fileStructureNode.isFile() ? "-" : Integer.valueOf(this.fileStructureNode.getDescendantCount());
                }
                case 10: {
                    return Integer.valueOf(this.fileStructureNode.getMyEvents().size()).toString();
                }
                case 11: {
                    return I18N.translate((String)this.fileStructureNode.getSubmitStatus().toString());
                }
                case 12: {
                    if (this.fileStructureNode.isFolder()) {
                        return null;
                    }
                    NodeFile targetNode = ((NodeFile)this.fileStructureNode).getMigrationDerivedNode();
                    if (targetNode != null) {
                        return I18N.translate((String)"PreservationRoleMaster");
                    }
                    targetNode = ((NodeFile)this.fileStructureNode).getMigrationSourceNode();
                    if (targetNode != null) {
                        return I18N.translate((String)"PreservationRoleDerivate");
                    }
                    return null;
                }
            }
        }
        return null;
    }
}

