/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.automata.trie;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.byteseek.automata.MutableAutomata;
import net.byteseek.automata.State;
import net.byteseek.automata.Transition;
import net.byteseek.automata.factory.MutableStateFactory;
import net.byteseek.automata.factory.StateFactory;
import net.byteseek.automata.factory.TransitionFactory;
import net.byteseek.automata.trie.Trie;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public abstract class AbstractTrie<T>
extends MutableAutomata<T>
implements Trie<T> {
    private final StateFactory<T> stateFactory;
    private final TransitionFactory<T, Collection<Byte>> transitionFactory;
    private final List<T> sequences;
    private int minimumLength = -1;
    private int maximumLength = 0;

    public AbstractTrie() {
        this(null, null);
    }

    public AbstractTrie(StateFactory<T> stateFactory) {
        this(stateFactory, null);
    }

    public AbstractTrie(TransitionFactory<T, Collection<Byte>> transitionFactory) {
        this(null, transitionFactory);
    }

    public AbstractTrie(StateFactory<T> stateFactory, TransitionFactory<T, Collection<Byte>> transitionFactory) {
        ArgUtils.checkNullObject(transitionFactory, "transitionFactory");
        this.stateFactory = stateFactory != null ? stateFactory : new MutableStateFactory();
        this.transitionFactory = transitionFactory;
        this.sequences = new ArrayList<T>();
        this.setInitialState(this.stateFactory.create(false));
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public int getMinimumLength() {
        return this.minimumLength == -1 ? 0 : this.minimumLength;
    }

    @Override
    public int getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public Collection<T> getSequences() {
        return new ArrayList<T>(this.sequences);
    }

    @Override
    public void add(T sequence) {
        List<State<T>> currentStates = new ArrayList<State<T>>();
        currentStates.add(this.initialState);
        int length = this.getSequenceLength(sequence);
        for (int position = 0; position < length; ++position) {
            byte[] byArray = this.getBytesForPosition(sequence, position);
            boolean isFinal = position == length - 1;
            currentStates = this.nextStates(currentStates, byArray, isFinal);
        }
        for (State state : currentStates) {
            state.addAssociation(sequence);
        }
        this.setMinMaxLength(length);
        this.sequences.add(sequence);
    }

    @Override
    public void addAll(Collection<? extends T> sequencesToAdd) {
        for (T sequence : sequencesToAdd) {
            this.add(sequence);
        }
    }

    @Override
    public void addReversed(T sequence) {
        List<State<T>> currentStates = new ArrayList<State<T>>();
        currentStates.add(this.initialState);
        int length = this.getSequenceLength(sequence);
        for (int position = length - 1; position >= 0; --position) {
            byte[] byArray = this.getBytesForPosition(sequence, position);
            boolean isFinal = position == 0;
            currentStates = this.nextStates(currentStates, byArray, isFinal);
        }
        for (State state : currentStates) {
            state.addAssociation(sequence);
        }
        this.setMinMaxLength(length);
        this.sequences.add(sequence);
    }

    @Override
    public void addAllReversed(Collection<? extends T> sequencesToAdd) {
        for (T sequence : sequencesToAdd) {
            this.addReversed(sequence);
        }
    }

    protected abstract int getSequenceLength(T var1);

    protected abstract byte[] getBytesForPosition(T var1, int var2);

    private void setMinMaxLength(int length) {
        if (length > this.maximumLength) {
            this.maximumLength = length;
        }
        if (length < this.minimumLength || this.minimumLength == -1) {
            this.minimumLength = length;
        }
    }

    private List<State<T>> nextStates(List<State<T>> currentStates, byte[] bytes, boolean isFinal) {
        ArrayList<State<T>> nextStates = new ArrayList<State<T>>();
        Set<Byte> allBytesToTransitionOn = ByteUtils.toSet(bytes);
        for (State<T> currentState : currentStates) {
            int numberOfBytesLeft;
            ArrayList<Transition<T>> stateTransitions = new ArrayList<Transition<T>>(currentState.getTransitions());
            HashSet<Byte> bytesToTransitionOn = new HashSet<Byte>(allBytesToTransitionOn);
            for (Transition transition : stateTransitions) {
                int numberOfBytesLeft2;
                Set<Byte> originalTransitionBytes = ByteUtils.toSet(transition.getBytes());
                int originalTransitionBytesSize = originalTransitionBytes.size();
                List<Byte> bytesInCommon = ByteUtils.removeIntersection(originalTransitionBytes, bytesToTransitionOn);
                int numberOfBytesInCommon = bytesInCommon.size();
                if (numberOfBytesInCommon == originalTransitionBytesSize) {
                    State toState = transition.getToState();
                    if (isFinal) {
                        toState.setIsFinal(true);
                    }
                    nextStates.add(toState);
                } else if (numberOfBytesInCommon > 0) {
                    State originalToState = transition.getToState();
                    if (isFinal) {
                        originalToState.setIsFinal(true);
                    }
                    State newToState = originalToState.deepCopy();
                    currentState.addTransition(this.transitionFactory.create(originalTransitionBytes, false, originalToState));
                    currentState.addTransition(this.transitionFactory.create(bytesInCommon, false, newToState));
                    nextStates.add(newToState);
                    currentState.removeTransition(transition);
                }
                if ((numberOfBytesLeft2 = bytesToTransitionOn.size()) != 0) continue;
                break;
            }
            if ((numberOfBytesLeft = bytesToTransitionOn.size()) <= 0) continue;
            State<T> state = this.stateFactory.create(isFinal);
            Transition<T> newTransition = this.transitionFactory.create(bytesToTransitionOn, false, state);
            currentState.addTransition(newTransition);
            nextStates.add(state);
        }
        return nextStates;
    }
}

