/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader;

import java.io.IOException;
import java.io.InputStream;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.utils.ArgUtils;

public final class ReaderInputStream
extends InputStream {
    private final WindowReader reader;
    private final boolean closeReaderOnClose;
    private final boolean markSupported;
    private long pos;
    private long mark;
    private Window currentWindow;
    private int currentWindowLength;
    private byte[] currentArray;
    private int currentArrayPos;

    public ReaderInputStream(WindowReader reader) throws IOException {
        this(reader, true);
    }

    public ReaderInputStream(WindowReader reader, boolean closeReaderOnClose) throws IOException {
        this(reader, closeReaderOnClose, true);
    }

    public ReaderInputStream(WindowReader reader, boolean closeReaderOnClose, boolean markSupported) throws IOException {
        ArgUtils.checkNullObject(reader, "reader");
        this.reader = reader;
        this.closeReaderOnClose = closeReaderOnClose;
        this.markSupported = markSupported;
        this.setWindowForPosition(0L);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.pos > -1L) {
            int readResult = this.currentArray[this.currentArrayPos] & 0xFF;
            this.addStreamPosition(1);
            return readResult;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.pos > -1L) {
            int copied;
            int available = this.currentWindowLength - this.currentArrayPos;
            if (available >= len) {
                System.arraycopy(this.currentArray, this.currentArrayPos, b, off, len);
                this.addStreamPosition(len);
                return len;
            }
            for (copied = 0; copied < len; copied += available) {
                System.arraycopy(this.currentArray, this.currentArrayPos, b, off + copied, available);
                this.addStreamPosition(available);
                if (this.currentWindow == null) break;
                int remaining = len - copied;
                available = this.currentWindowLength > remaining ? remaining : this.currentWindowLength;
            }
            return copied;
        }
        return -1;
    }

    @Override
    public synchronized int available() throws IOException {
        return this.pos > -1L ? this.currentWindowLength - this.currentArrayPos : 0;
    }

    @Override
    public boolean markSupported() {
        return this.markSupported;
    }

    @Override
    public synchronized void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markSupported) {
            this.setWindowForPosition(this.mark);
        } else {
            super.reset();
        }
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n <= 0L || this.pos < 0L) {
            return 0L;
        }
        long oldPos = this.pos;
        this.setWindowForPosition(this.pos + n);
        return this.currentWindow == null ? this.reader.length() - oldPos : n;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closeReaderOnClose) {
            this.reader.close();
            this.setNoMoreData();
        }
    }

    synchronized long getNextReadPos() {
        return this.pos;
    }

    private void setWindowForPosition(long newPos) throws IOException {
        this.currentWindow = this.reader.getWindow(newPos);
        if (this.currentWindow == null) {
            this.setNoMoreData();
        } else {
            this.pos = newPos;
            this.currentWindowLength = this.currentWindow.length();
            this.currentArray = this.currentWindow.getArray();
            this.currentArrayPos = this.reader.getWindowOffset(newPos);
        }
    }

    private void addStreamPosition(int moveBy) throws IOException {
        this.currentArrayPos += moveBy;
        this.pos += (long)moveBy;
        if (this.currentArrayPos >= this.currentWindowLength) {
            this.setWindowForPosition(this.pos);
        }
    }

    private void setNoMoreData() {
        this.pos = -1L;
        this.currentWindowLength = 0;
        this.currentArray = null;
        this.currentArrayPos = 0;
    }
}

