/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.cache;

import java.io.IOException;
import net.byteseek.io.reader.cache.AbstractFreeNotificationCache;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.utils.collections.LongLinkedHashMap;

public final class LeastRecentlyUsedCache
extends AbstractFreeNotificationCache {
    private final Cache cache;

    public LeastRecentlyUsedCache(int capacity) {
        this.cache = new Cache(capacity);
    }

    @Override
    public Window getWindow(long position) {
        return (Window)this.cache.get(position);
    }

    @Override
    public void addWindow(Window window) throws IOException {
        long windowPosition = window.getWindowPosition();
        if (!this.cache.containsKey(windowPosition)) {
            this.cache.put(windowPosition, window);
            this.cache.checkIOException();
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[size: " + this.cache.size() + " capacity: " + this.cache.capacity + ']';
    }

    private class Cache
    extends LongLinkedHashMap<Window> {
        private final int capacity;
        private IOException exception;

        private Cache(int capacity) {
            super(capacity + 1, 1.1f, true);
            this.exception = null;
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(LongLinkedHashMap.MapEntry<Window> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > this.capacity;
            if (remove) {
                try {
                    LeastRecentlyUsedCache.this.notifyWindowFree(eldest.getValue(), LeastRecentlyUsedCache.this);
                }
                catch (IOException ex) {
                    this.exception = ex;
                }
            }
            return remove;
        }

        public void checkIOException() throws IOException {
            if (this.exception != null) {
                IOException ex = this.exception;
                this.exception = null;
                throw ex;
            }
        }
    }
}

