/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.job.AbstractSourceDocumentSpecs;
import org.jodconverter.core.job.DocumentSpecsIOException;
import org.jodconverter.core.job.SourceDocumentSpecs;
import org.jodconverter.core.office.TemporaryFileMaker;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.core.util.FileUtils;
import org.jodconverter.core.util.IOUtils;

public class SourceDocumentSpecsFromInputStream
extends AbstractSourceDocumentSpecs
implements SourceDocumentSpecs {
    private final InputStream inputStream;
    private final TemporaryFileMaker fileMaker;
    private final boolean closeStream;

    public SourceDocumentSpecsFromInputStream(@NonNull InputStream inputStream, @NonNull TemporaryFileMaker fileMaker, boolean closeStream) {
        AssertUtils.notNull(inputStream, "inputStream must not be null");
        AssertUtils.notNull(fileMaker, "fileMaker must not be null");
        this.inputStream = inputStream;
        this.fileMaker = fileMaker;
        this.closeStream = closeStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull File getFile() {
        File file;
        File tempFile = Optional.ofNullable(this.getFormat()).map(format -> this.fileMaker.makeTemporaryFile(format.getExtension())).orElse(this.fileMaker.makeTemporaryFile());
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        outputStream.getChannel().lock();
        try {
            IOUtils.copy(this.inputStream, outputStream);
            file = tempFile;
        }
        catch (Throwable throwable) {
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new DocumentSpecsIOException(String.format("Could not write stream to file '%s'", tempFile), ex);
            }
        }
        outputStream.close();
        return file;
    }

    @Override
    public void onConsumed(@NonNull File tempFile) {
        FileUtils.deleteQuietly(tempFile);
        if (this.closeStream) {
            try {
                this.inputStream.close();
            }
            catch (IOException ex) {
                throw new DocumentSpecsIOException("Could not close input stream", ex);
            }
        }
    }
}

