/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.filePreview;

import ch.docuteam.tools.file.ResourceUtil;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.util.Properties;

public class FilePreviewConfigurator {
    public static final String NOT_CONFIGURED_EXCEPTION = "MessageFilePreviewConfiguratorPropertiesNotFound";
    private String configFileName = "/config/filePreviewConfigurator.properties";
    private Properties properties;

    public FilePreviewConfigurator() {
        this.initialize();
    }

    FilePreviewConfigurator(String configFileName) {
        this.configFileName = configFileName;
        this.initialize();
    }

    private void initialize() {
        this.properties = ResourceUtil.getProperties((String)this.configFileName);
        if (this.getProperties().keySet().isEmpty()) {
            Logger.warn((Object)I18N.translate((String)NOT_CONFIGURED_EXCEPTION, (Object[])new Object[]{this.configFileName}));
        }
        for (String string : this.getProperties().keySet()) {
            String propertyValue = this.getPropertyValue(string);
            Logger.debug((Object)("filePreviewConfigurator properties: " + string + " -> " + propertyValue));
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPropertyValue(String key) {
        return this.properties.getProperty(key);
    }
}

