/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher.actions;

import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.packer.gui.launcher.actions.AbstractDocuAction;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URI;

public class HelpAction
extends AbstractDocuAction {
    private static final long serialVersionUID = 1L;

    public HelpAction(LauncherView owner) {
        super(I18N.translate((String)"ActionHelp"), PackerConstants.getImageIcon("Help.png"), owner);
        this.putValue("ShortDescription", I18N.translate((String)"ToolTipHelp"));
        this.putValue("AcceleratorKey", owner.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), 112, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!Desktop.isDesktopSupported()) {
            System.err.println("Desktop is not supported");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            System.err.println("Desktop doesn't support the browse action");
            return;
        }
        try {
            desktop.browse(new URI(I18N.translate((String)"HelpPageURL")));
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

