/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.darc.exceptions.CantCreateTemplateWithRootFileException;
import ch.docuteam.darc.exceptions.CantSetSubmitStatusNotAllowedException;
import ch.docuteam.darc.exceptions.CantSetSubmitStatusRecursiveException;
import ch.docuteam.darc.exceptions.DocumentIsReadOnlyException;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FileOrFolderIsInUseException;
import ch.docuteam.darc.exceptions.MetadataElementCantAddException;
import ch.docuteam.darc.exceptions.MetadataElementCantDeleteException;
import ch.docuteam.darc.exceptions.NodeWithLevelNotRemovableException;
import ch.docuteam.darc.exceptions.OriginalSIPIsMissingException;
import ch.docuteam.darc.exceptions.ZIPDoesNotContainMETSFileException;
import ch.docuteam.darc.ingest.AIPCreatorProxy;
import ch.docuteam.darc.mdconfig.LevelMetadataElement;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.MetadataElementInstance;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.darc.premis.Event;
import ch.docuteam.darc.util.CSVExport;
import ch.docuteam.darc.util.XMLTransformer;
import ch.docuteam.darc.util.file.FileNameNormalizer;
import ch.docuteam.mapping.ExporterSEDA;
import ch.docuteam.mapping.seda1.Exporter;
import ch.docuteam.packer.gui.FileProperty;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.filePreview.FilePreviewer;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.packer.gui.sipView.AssignLevelsByLabelDialog;
import ch.docuteam.packer.gui.sipView.AssignLevelsByLayerDialog;
import ch.docuteam.packer.gui.sipView.DuplicatesTableDialog;
import ch.docuteam.packer.gui.sipView.ElementNamingDialog;
import ch.docuteam.packer.gui.sipView.MetadataTable;
import ch.docuteam.packer.gui.sipView.SearchPanel;
import ch.docuteam.packer.gui.sipView.TestOrAssignSADialog;
import ch.docuteam.packer.gui.sipView.TreeTableTransferHandler;
import ch.docuteam.packer.gui.sipView.actions.AppendMigratedFileAction;
import ch.docuteam.packer.gui.sipView.actions.CheckFixityAction;
import ch.docuteam.packer.gui.sipView.actions.ConvertFilesAction;
import ch.docuteam.packer.gui.sipView.actions.DeleteFileContentAction;
import ch.docuteam.packer.gui.sipView.actions.DeleteItemAction;
import ch.docuteam.packer.gui.sipView.actions.ExploreAction;
import ch.docuteam.packer.gui.sipView.actions.ImportMetadataFromCSVAction;
import ch.docuteam.packer.gui.sipView.cellRenderer.HasMandatoryMetadataFieldsNotSetCellRenderer;
import ch.docuteam.packer.gui.sipView.cellRenderer.MyTreeCellRenderer;
import ch.docuteam.packer.gui.sipView.cellRenderer.RelativeSizeBarTableCellRenderer;
import ch.docuteam.packer.gui.sipView.cellRenderer.SubmitStatusTableCellRenderer;
import ch.docuteam.packer.gui.sipView.tableModel.EventDetailTableModel;
import ch.docuteam.packer.gui.sipView.tableModel.EventListTableModel;
import ch.docuteam.packer.gui.sipView.tableModel.FileDataViewTableModel;
import ch.docuteam.packer.gui.sipView.tableModel.MetadataTableModel;
import ch.docuteam.packer.gui.sipView.tableModel.TreeTableModel;
import ch.docuteam.packer.gui.util.Util;
import ch.docuteam.tools.exception.Exception;
import ch.docuteam.tools.exception.ExceptionCollector;
import ch.docuteam.tools.exception.ExceptionCollectorException;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.gui.JTableWithDynamicToolTipTexts;
import ch.docuteam.tools.gui.ScrollableMessageDialog;
import ch.docuteam.tools.gui.SmallPeskyMessageWindow;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Optional;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import javax.xml.transform.TransformerException;
import org.dom4j.DocumentException;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class SIPView
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String REPORT_STYLESHEET_PREFIX_SOURCE_TYPE_METS = "METS_";
    private static final String REPORT_STYLESHEET_PREFIX_SOURCE_TYPE_EAD = "EAD_";
    private static final String REPORT_STYLESHEET_SUFFIX_OUTPUT_FORMAT_CSV = "_CSV";
    private static final String OUTPUT_FORMAT_CSV = "csv";
    private static final String OUTPUT_FORMAT_PDF = "pdf";
    protected static final Color ColorFGForNonReadableFile = Color.WHITE;
    protected static final Color ColorBGForNonReadableFile = Color.LIGHT_GRAY;
    protected static final Color ColorFGForNonWritableFile = null;
    protected static final Color ColorBGForNonWritableFile = new Color(253, 152, 154);
    protected static String DefaultFrameTitle = "";
    protected static Boolean openFullScreen = false;
    public static boolean saveWithBackups = true;
    protected static Integer screenPosX = null;
    protected static Integer screenPosY = null;
    protected static Integer screenSizeX = 1000;
    protected static Integer screenSizeY = 700;
    private static Properties properties;
    protected LauncherView launcherView;
    protected JXTreeTable treeTable;
    protected JTableWithDynamicToolTipTexts dataTable;
    protected JTable eventTable;
    protected JTableWithDynamicToolTipTexts eventDetailTable;
    protected MetadataTable metadataTable;
    private JScrollPane metadataTableScrollPane;
    protected JLabel infoLabel;
    protected JLabel fileDataPropertiesLabel;
    protected JLabel fileDateEventsLabel;
    protected JLabel fileDataEventsDetailsLabel;
    protected JTextField metaTitleTextField;
    protected JTextField metaLevelTextField;
    protected JButton logoButton;
    protected JTextField footerTextField;
    protected JSplitPane splitPane;
    protected JTabbedPane tabbedPane;
    protected FilePreviewer previewPanel;
    protected Action insertAction;
    protected Action saveAction;
    protected Action closeAction;
    protected Action saveAsAction;
    protected Action createFolderAction;
    protected Action renameItemAction;
    protected Action replaceFileAction;
    protected AppendMigratedFileAction appendMigratedFileAction;
    protected Action deleteItemAction;
    protected Action deleteItemDontAskAction;
    protected DeleteFileContentAction deleteFileContentAction;
    protected Action openSAExternallyAction;
    protected Action testOrAssignSAAction;
    protected Action openAssignLevelsByLayerViewAction;
    protected Action openAssignLevelsByLabelViewAction;
    protected ImportMetadataFromCSVAction importMetadataFromCSVMenuAction;
    protected ImportMetadataFromCSVAction importMetadataFromCSVContextAction;
    protected Action exportAsEADFileAction;
    protected Action exportAsCSVFileAction;
    private Action exportAsSEDA21Action;
    private Action exportAsSEDA1Action;
    protected Action openDocuteamHomepageAction;
    protected Action expandAllAction;
    protected Action collapseAllAction;
    protected Action removeMetadataElementAction;
    protected Action insertMetadataElementAction;
    protected Action redisplayNodeAction;
    protected Action systemOutDocumentAction;
    protected Action exportAction;
    protected Action saveAsTemplateAction;
    protected CheckFixityAction checkFixityAction;
    protected ExploreAction exploreAction;
    protected Action submitRequestAction;
    protected Action submitRetractAction;
    protected Action submitCheckAction;
    protected Action submitAction;
    protected Action sortAction;
    private ConvertFilesAction convertAction;
    private AbstractAction normalizeAction;
    private Action removeTrashAction;
    private Action removeDuplicatesAction;
    protected JComboBox<LevelMetadataElement> selectMetadataElementComboBox;
    protected List<Action> setLevelActions;
    protected JMenu fileMenu;
    protected JMenu mdExportSubMenu;
    private JMenu sipExportSubMenu;
    protected JMenu searchMenu;
    protected JMenu viewMenu;
    protected JMenu itemMenu;
    protected JMenu itemLevelsSubMenu;
    protected JMenu saMenu;
    protected JMenu reportsSubMenu;
    protected JPopupMenu popupMenu;
    protected int popupMenuStartOfLevelsSubMenu;
    protected FileProperty fileProperty;
    protected Document document;
    protected NodeAbstract selectedNode;
    protected int selectedIndex = -1;

    protected SIPView(LauncherView launcherView) {
        super(DefaultFrameTitle);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SIPView.this.closeButtonClicked();
            }
        });
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.launcherView = launcherView;
        this.treeTable = new JXTreeTable(new TreeTableModel(null));
        this.treeTable.setName("SIP_VIEW_TREE");
        HighlightPredicate nonWritablePredicate = new HighlightPredicate(){

            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                try {
                    return !((NodeAbstract)SIPView.this.treeTable.getPathForRow(adapter.row).getLastPathComponent()).canWrite();
                }
                catch (NullPointerException ex) {
                    return false;
                }
            }
        };
        this.treeTable.addHighlighter(new ColorHighlighter(nonWritablePredicate, ColorBGForNonWritableFile, ColorFGForNonWritableFile));
        HighlightPredicate nonReadablePredicate = new HighlightPredicate(){

            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                try {
                    NodeAbstract node = (NodeAbstract)SIPView.this.treeTable.getPathForRow(adapter.row).getLastPathComponent();
                    return !node.fileExists() || !node.canRead();
                }
                catch (NullPointerException ex) {
                    return false;
                }
            }
        };
        this.treeTable.addHighlighter(new ColorHighlighter(nonReadablePredicate, ColorBGForNonReadableFile, ColorFGForNonReadableFile));
        this.treeTable.setEnabled(true);
        this.treeTable.setAutoCreateColumnsFromModel(false);
        this.treeTable.setRootVisible(true);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.setSelectionMode(2);
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SIPView.this.treeViewSelectionChanged(e);
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SIPView.this.treeViewSelectionWasClicked(e);
            }
        });
        this.treeTable.setDragEnabled(true);
        this.treeTable.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.treeTable.setTransferHandler(new TreeTableTransferHandler(this));
        this.treeTable.setTreeCellRenderer(new MyTreeCellRenderer());
        this.treeTable.getColumn(0).setPreferredWidth(300);
        this.treeTable.getColumn(1).setPreferredWidth(30);
        this.treeTable.getColumn(2).setPreferredWidth(10);
        this.treeTable.getColumn(3).setPreferredWidth(100);
        this.treeTable.getColumn(3).setCellRenderer(new RelativeSizeBarTableCellRenderer(this.treeTable.getColumn(3)));
        this.treeTable.getColumn(4).setMaxWidth(10);
        this.treeTable.getColumn(4).setCellRenderer(new HasMandatoryMetadataFieldsNotSetCellRenderer());
        this.treeTable.getColumn(5).setMaxWidth(12);
        this.treeTable.getColumn(5).setCellRenderer(new SubmitStatusTableCellRenderer());
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0), "Collapse");
        this.treeTable.getActionMap().put("Collapse", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.collapseCurrentNode();
            }
        });
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0), "Expand");
        this.treeTable.getActionMap().put("Expand", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.expandCurrentNode();
            }
        });
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Collapse all");
        this.treeTable.getActionMap().put("Collapse all", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.treeTable.collapseAll();
            }
        });
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Expand all");
        this.treeTable.getActionMap().put("Expand all", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.expandAll();
            }
        });
        this.dataTable = new JTableWithDynamicToolTipTexts((TableModel)new FileDataViewTableModel(), new int[]{1});
        this.dataTable.setEnabled(false);
        this.dataTable.getColumnModel().getColumn(0).setMaxWidth(125);
        this.dataTable.getColumnModel().getColumn(0).setMinWidth(125);
        this.dataTable.setGridColor(Color.LIGHT_GRAY);
        this.eventTable = new JTable(new EventListTableModel());
        this.eventTable.setName("SIP_VIEW_EVENT_TABLE");
        this.eventTable.setEnabled(true);
        this.eventTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SIPView.this.eventTableSelectionChanged(e);
            }
        });
        this.eventTable.setGridColor(Color.LIGHT_GRAY);
        this.eventDetailTable = new JTableWithDynamicToolTipTexts((TableModel)new EventDetailTableModel(), new int[]{1});
        this.eventDetailTable.setEnabled(false);
        this.eventDetailTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.eventDetailTable.getColumnModel().getColumn(0).setMinWidth(100);
        this.eventDetailTable.setGridColor(Color.LIGHT_GRAY);
        this.metadataTable = new MetadataTable(new MetadataTableModel(this), 2);
        this.metadataTable.setEnabled(true);
        this.metadataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SIPView.this.metadataTableSelectionChanged(e);
            }
        });
        this.metadataTable.setSelectionMode(0);
        this.metadataTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.metadataTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.metadataTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.metadataTable.getColumnModel().getColumn(1).setMaxWidth(300);
        this.metadataTable.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.metadataTable.setGridColor(Color.LIGHT_GRAY);
        this.metadataTable.setAutoscrolls(true);
        this.metaTitleTextField = new JTextField();
        this.metaTitleTextField.setName("SIP_VIEW_METADATA_UNITTITLE_TEXTFIELD");
        this.metaTitleTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SIPView.this.metaTitleTextFieldWasChanged();
            }
        });
        this.metaTitleTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.metaTitleTextFieldWasChanged();
            }
        });
        this.metaLevelTextField = new JTextField();
        this.metaLevelTextField.setEditable(false);
        this.selectMetadataElementComboBox = new JComboBox();
        this.selectMetadataElementComboBox.setEnabled(false);
        this.selectMetadataElementComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.enableOrDisableActions();
            }
        });
        this.selectMetadataElementComboBox.setToolTipText(I18N.translate((String)"ToolTipSelectMetadataElement"));
        this.saveAction = new AbstractAction(I18N.translate((String)"ButtonSave"), PackerConstants.getImageIcon("Save.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.saveButtonClicked(e);
            }
        };
        this.saveAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.saveAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSave"));
        this.saveAction.setEnabled(true);
        this.saveAsAction = new AbstractAction(I18N.translate((String)"ButtonSaveAs"), PackerConstants.getImageIcon("Save.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.saveAsButtonClicked();
            }
        };
        this.saveAsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        this.saveAsAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSaveAs"));
        this.saveAsAction.setEnabled(true);
        this.closeAction = new AbstractAction(I18N.translate((String)"ButtonClose"), PackerConstants.getImageIcon("Close.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.closeButtonClicked();
            }
        };
        this.closeAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.closeAction.putValue("ShortDescription", I18N.translate((String)"ToolTipClose"));
        this.closeAction.setEnabled(true);
        this.insertAction = new AbstractAction(I18N.translate((String)"ButtonInsert"), PackerConstants.getImageIcon("Insert.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.insertFileOrFolderButtonClicked();
            }
        };
        this.insertAction.putValue("ShortDescription", I18N.translate((String)"ToolTipInsert"));
        this.insertAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.insertAction.setEnabled(false);
        this.createFolderAction = new AbstractAction(I18N.translate((String)"ButtonCreateFolder"), PackerConstants.getImageIcon("AddFolder.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.createFolderButtonClicked();
            }
        };
        this.createFolderAction.putValue("ShortDescription", I18N.translate((String)"ToolTipCreateFolder"));
        this.createFolderAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.createFolderAction.setEnabled(false);
        this.renameItemAction = new AbstractAction(I18N.translate((String)"ButtonRenameItem"), PackerConstants.getImageIcon("Rename.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.renameItemButtonClicked();
            }
        };
        this.renameItemAction.putValue("AcceleratorKey", this.launcherView.getKeyStroke(82, 512, 113, 512, 113, 128));
        this.renameItemAction.putValue("ShortDescription", I18N.translate((String)"ToolTipRenameItem"));
        this.renameItemAction.setEnabled(false);
        this.sortAction = new AbstractAction(I18N.translate((String)"ButtonSort"), PackerConstants.getImageIcon("Sort.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.sortButtonClicked();
            }
        };
        this.sortAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSort"));
        this.sortAction.setEnabled(false);
        this.normalizeAction = new AbstractAction(I18N.translate((String)"ButtonNormalizeFileNames"), PackerConstants.getImageIcon("Normalize.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.normalizeButtonClicked();
            }
        };
        this.normalizeAction.putValue("ShortDescription", I18N.translate((String)"ToolTipButtonNormalizeFileNames"));
        this.normalizeAction.setEnabled(false);
        this.deleteItemAction = new DeleteItemAction(this);
        this.deleteItemAction.setEnabled(false);
        this.deleteItemAction.putValue("actionHideKey", "deleteItemAction");
        this.deleteItemDontAskAction = new AbstractAction(I18N.translate((String)"ButtonDeleteItemDontAsk"), PackerConstants.getImageIcon("Delete.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.deleteItemDontAskButtonClicked();
            }
        };
        this.deleteItemDontAskAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40));
        this.deleteItemDontAskAction.putValue("ShortDescription", I18N.translate((String)"ToolTipDeleteItemDontAsk"));
        this.deleteItemDontAskAction.setEnabled(false);
        this.deleteItemDontAskAction.putValue("actionHideKey", "deleteItemDontAskAction");
        this.deleteFileContentAction = new DeleteFileContentAction(this);
        this.deleteFileContentAction.setEnabled(false);
        this.deleteFileContentAction.putValue("actionHideKey", "deleteFileContentAction");
        this.replaceFileAction = new AbstractAction(I18N.translate((String)"ButtonReplaceFile"), PackerConstants.getImageIcon("Replace.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.replaceFileButtonClicked();
            }
        };
        this.replaceFileAction.putValue("ShortDescription", I18N.translate((String)"ToolTipReplaceFile"));
        this.replaceFileAction.setEnabled(false);
        this.appendMigratedFileAction = new AppendMigratedFileAction(this);
        this.appendMigratedFileAction.setEnabled(false);
        this.openSAExternallyAction = new AbstractAction(I18N.translate((String)"ButtonOpenSAExternally"), PackerConstants.getImageIcon("View.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.openSAExternallyButtonClicked();
            }
        };
        this.openSAExternallyAction.putValue("ShortDescription", I18N.translate((String)"ToolTipOpenSAExternally"));
        this.openSAExternallyAction.setEnabled(false);
        this.testOrAssignSAAction = new AbstractAction(I18N.translate((String)"ButtonTestOrAssignSA"), PackerConstants.getImageIcon("CheckSA.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.testOrAssignSAButtonClicked();
            }
        };
        this.testOrAssignSAAction.putValue("ShortDescription", I18N.translate((String)"ToolTipTestOrAssignSA"));
        this.testOrAssignSAAction.setEnabled(false);
        this.openAssignLevelsByLayerViewAction = new AbstractAction(I18N.translate((String)"ButtonOpenAssignLevelsByLayerView"), PackerConstants.getImageIcon("Structure.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.openAssignLevelsByLayerViewButtonClicked();
            }
        };
        this.openAssignLevelsByLayerViewAction.putValue("ShortDescription", I18N.translate((String)"ToolTipOpenAssignLevelsByLayerView"));
        this.openAssignLevelsByLayerViewAction.setEnabled(true);
        this.openAssignLevelsByLabelViewAction = new AbstractAction(I18N.translate((String)"ButtonOpenAssignLevelsByLabelView"), PackerConstants.getImageIcon("Structure.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.openAssignLevelsByLabelViewButtonClicked();
            }
        };
        this.openAssignLevelsByLabelViewAction.putValue("ShortDescription", I18N.translate((String)"ToolTipOpenAssignLevelsByLabelView"));
        this.openAssignLevelsByLabelViewAction.setEnabled(true);
        this.importMetadataFromCSVMenuAction = new ImportMetadataFromCSVAction(this, false);
        this.importMetadataFromCSVContextAction = new ImportMetadataFromCSVAction(this, true);
        this.exportAsEADFileAction = new AbstractAction(I18N.translate((String)"ButtonExportAsEADFile"), PackerConstants.getImageIcon("ExportAsEADFile.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.exportAsEADFileButtonClicked();
            }
        };
        this.exportAsEADFileAction.putValue("ShortDescription", I18N.translate((String)"ToolTipExportAsEADFile"));
        this.exportAsEADFileAction.setEnabled(true);
        this.exportAsCSVFileAction = new AbstractAction(I18N.translate((String)"ButtonExportAsCSVFile"), PackerConstants.getImageIcon("ExportAsCSVFile.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.exportAsCSVFileButtonClicked();
            }
        };
        this.exportAsCSVFileAction.putValue("ShortDescription", I18N.translate((String)"ToolTipExportAsCSVFile"));
        this.exportAsCSVFileAction.setEnabled(true);
        this.exportAsSEDA21Action = new AbstractAction(I18N.translate((String)"ExportAsSEDA21Action"), PackerConstants.getImageIcon("ExportAsSEDA21.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.exportAsSEDA_ActionButtonClicked((ExporterSEDA)new ch.docuteam.mapping.seda21.Exporter(), "TitleSaveSIPAsSEDA21_SIP", "ExportAsSEDA21ActionSuccess", "ExportAsSEDA21ActionFailure");
            }
        };
        this.exportAsSEDA21Action.putValue("ShortDescription", I18N.translate((String)"ToolTipExportAsSEDA21Action"));
        this.exportAsSEDA21Action.setEnabled(true);
        this.exportAsSEDA1Action = new AbstractAction(I18N.translate((String)"ExportAsSEDA1Action"), PackerConstants.getImageIcon("ExportAsSEDA1.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.exportAsSEDA_ActionButtonClicked((ExporterSEDA)new Exporter(), "TitleSaveSIPAsSEDA1_SIP", "ExportAsSEDA1ActionSuccess", "ExportAsSEDA1ActionFailure");
            }
        };
        this.exportAsSEDA1Action.putValue("ShortDescription", I18N.translate((String)"ToolTipExportAsSEDA1Action"));
        this.exportAsSEDA1Action.setEnabled(true);
        this.exportAction = new AbstractAction(I18N.translate((String)"ButtonExport"), PackerConstants.getImageIcon("Export.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.exportButtonClicked();
            }
        };
        this.exportAction.putValue("ShortDescription", I18N.translate((String)"ToolTipExport"));
        this.exportAction.setEnabled(false);
        this.openDocuteamHomepageAction = new AbstractAction(I18N.translate((String)"ButtonOpenDocuteamHomepage"), PackerConstants.getImageIcon("Home.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.openDocuteamHomepage();
            }
        };
        this.openDocuteamHomepageAction.putValue("ShortDescription", I18N.translate((String)"ToolTipOpenDocuteamHomepage"));
        this.openDocuteamHomepageAction.setEnabled(true);
        this.saveAsTemplateAction = new AbstractAction(I18N.translate((String)"ButtonSaveAsTemplate"), PackerConstants.getImageIcon("Save.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.saveAsTemplateButtonClicked();
            }
        };
        if (!OperatingSystem.isLinux()) {
            this.saveAsTemplateAction.putValue("AcceleratorKey", this.launcherView.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x200));
        }
        this.saveAsTemplateAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSaveAsTemplate"));
        this.saveAsTemplateAction.setEnabled(true);
        this.expandAllAction = new AbstractAction(I18N.translate((String)"ButtonExpandAll"), PackerConstants.getImageIcon("ExpandAll.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.expandAll();
            }
        };
        this.expandAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 512));
        this.expandAllAction.setEnabled(false);
        this.collapseAllAction = new AbstractAction(I18N.translate((String)"ButtonCollapseAll"), PackerConstants.getImageIcon("CollapseAll.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.treeTable.collapseAll();
            }
        };
        this.collapseAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 512));
        this.collapseAllAction.setEnabled(false);
        this.removeMetadataElementAction = new AbstractAction(I18N.translate((String)"ButtonRemoveMetadataElement"), PackerConstants.getImageIcon("Delete.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.removeMetadataElement();
            }
        };
        this.removeMetadataElementAction.putValue("ShortDescription", I18N.translate((String)"ToolTipRemoveMetadataElement"));
        this.removeMetadataElementAction.setEnabled(false);
        this.insertMetadataElementAction = new AbstractAction(I18N.translate((String)"ButtonInsertMetadataElement"), PackerConstants.getImageIcon("Insert.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.insertMetadataElement();
            }
        };
        this.insertMetadataElementAction.putValue("ShortDescription", I18N.translate((String)"ToolTipInsertMetadataElement"));
        this.insertMetadataElementAction.setEnabled(false);
        this.redisplayNodeAction = new AbstractAction(I18N.translate((String)"ButtonRedisplayNode"), PackerConstants.getImageIcon("Redisplay.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.redisplayNode();
            }
        };
        this.redisplayNodeAction.putValue("ShortDescription", I18N.translate((String)"ToolTipRedisplayNode"));
        this.redisplayNodeAction.putValue("AcceleratorKey", launcherView.getKeyStroke(116, 0, 82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.checkFixityAction = new CheckFixityAction(this);
        this.checkFixityAction.setEnabled(false);
        this.convertAction = new ConvertFilesAction(this);
        this.convertAction.putValue("actionHideKey", "convertFilesAction");
        this.convertAction.setEnabled(false);
        this.exploreAction = new ExploreAction(this);
        this.exploreAction.putValue("actionHideKey", "exploreAction");
        this.submitRequestAction = new AbstractAction(I18N.translate((String)"ActionSubmitRequest"), PackerConstants.getImageIcon("SubmitRequest.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.setSubmitRequestButtonClicked();
            }
        };
        this.submitRequestAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSubmitRequest"));
        this.submitRetractAction = new AbstractAction(I18N.translate((String)"ActionSubmitRetract"), PackerConstants.getImageIcon("SubmitRetract.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.setSubmitRetractButtonClicked();
            }
        };
        this.submitRetractAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSubmitRetract"));
        this.submitCheckAction = new AbstractAction(I18N.translate((String)"ActionSubmitCheck"), PackerConstants.getImageIcon("SubmitCheck.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.checkSubmission();
            }
        };
        this.submitCheckAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSubmitCheck"));
        this.submitAction = new AbstractAction(I18N.translate((String)"ActionSubmit"), PackerConstants.getImageIcon("Submit.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.submit();
            }
        };
        this.submitAction.putValue("ShortDescription", I18N.translate((String)"ToolTipSubmit"));
        this.removeTrashAction = new AbstractAction(I18N.translate((String)"ActionRemoveTrash"), PackerConstants.getImageIcon("RemoveTrash.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.removeTrash();
            }
        };
        this.removeTrashAction.putValue("ShortDescription", I18N.translate((String)"ToolTipRemoveTrash"));
        this.removeTrashAction.setEnabled(false);
        this.removeDuplicatesAction = new AbstractAction(I18N.translate((String)"ActionRemoveDuplicates"), PackerConstants.getImageIcon("RemoveDuplicates.png")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.removeDuplicates();
            }
        };
        this.removeDuplicatesAction.putValue("ShortDescription", I18N.translate((String)"ToolTipRemoveDuplicates"));
        this.removeDuplicatesAction.setEnabled(false);
        JButton saveButton = new JButton(this.saveAction);
        saveButton.setName("SIP_SAVE_CURRENT_BUTTON");
        saveButton.setHideActionText(true);
        saveButton.setRequestFocusEnabled(false);
        JButton insertFileOrFolderButton = new JButton(this.insertAction);
        insertFileOrFolderButton.setHideActionText(true);
        insertFileOrFolderButton.setName("SIP_VIEW_INSERT_FILE_OR_FOLDER_BUTTON");
        insertFileOrFolderButton.setRequestFocusEnabled(false);
        JButton createFolderButton = new JButton(this.createFolderAction);
        createFolderButton.setHideActionText(true);
        createFolderButton.setRequestFocusEnabled(false);
        JButton renameItemButton = new JButton(this.renameItemAction);
        renameItemButton.setHideActionText(true);
        renameItemButton.setRequestFocusEnabled(false);
        JButton sortButton = new JButton(this.sortAction);
        sortButton.setName("SIP_SORT_BUTTON");
        sortButton.setHideActionText(true);
        sortButton.setRequestFocusEnabled(false);
        JButton normalizeButton = new JButton(this.normalizeAction);
        normalizeButton.setName("SIP_NORMALIZE_BUTTON");
        normalizeButton.setHideActionText(true);
        normalizeButton.setRequestFocusEnabled(false);
        JButton removeMetadataElementButton = new JButton(this.removeMetadataElementAction);
        removeMetadataElementButton.setHideActionText(true);
        removeMetadataElementButton.setRequestFocusEnabled(false);
        JButton insertMetadataElementButton = new JButton(this.insertMetadataElementAction);
        insertMetadataElementButton.setHideActionText(true);
        insertMetadataElementButton.setRequestFocusEnabled(false);
        this.logoButton = new JButton(PackerConstants.getImageIcon("Logo_docuteam_packer.png"));
        this.logoButton.setEnabled(true);
        this.logoButton.setHideActionText(true);
        this.logoButton.setRequestFocusEnabled(false);
        this.logoButton.setContentAreaFilled(false);
        this.logoButton.setBorderPainted(false);
        this.logoButton.setToolTipText(I18N.translate((String)"ToolTipOpenDocuteamHomepage"));
        this.logoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SIPView.this.openDocuteamHomepage();
            }
        });
        this.footerTextField = new JTextField();
        this.footerTextField.setEditable(false);
        this.footerTextField.setName("SIP_VIEW_FOOTER_TEXT_FIELD");
        this.infoLabel = new JLabel();
        this.infoLabel.setName("SIP_VIEW_INFO_LABEL");
        this.fileDataPropertiesLabel = new JLabel(I18N.translate((String)"LabelFileDataProperties"));
        this.fileDateEventsLabel = new JLabel(I18N.translate((String)"LabelFileDataEvents"));
        this.fileDataEventsDetailsLabel = new JLabel(I18N.translate((String)"LabelFileDataEventDetails"));
        SearchPanel searchPanel = new SearchPanel(this);
        this.mdExportSubMenu = new JMenu(I18N.translate((String)"MenuMetadataExport"));
        this.mdExportSubMenu.setName("SIP_METADATA_EXPORT_MENU");
        this.mdExportSubMenu.setIcon(PackerConstants.getImageIcon("Export.png"));
        this.mdExportSubMenu.setToolTipText(I18N.translate((String)"ToolTipMetadataExport"));
        JMenuItem eadExportMenuItem = new JMenuItem(this.exportAsEADFileAction);
        eadExportMenuItem.setName("SIP_EAD_EXPORT_MENU_ITEM");
        this.mdExportSubMenu.add(eadExportMenuItem);
        String[] xslt = new File(launcherView.getExportsDirectory()).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xsl");
            }
        });
        if (xslt != null && xslt.length > 0) {
            for (String export : xslt) {
                final String exportName = export.substring(0, export.length() - 4);
                AbstractAction action = new AbstractAction(exportName, PackerConstants.getImageIcon("ExportAsEADFile.png")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SIPView.this.createExport(exportName);
                    }
                };
                this.mdExportSubMenu.add(new JMenuItem(action));
            }
        }
        this.mdExportSubMenu.add(new JMenuItem(this.exportAsCSVFileAction));
        this.sipExportSubMenu = new JMenu(I18N.translate((String)"MenuSIPExport"));
        this.sipExportSubMenu.setIcon(PackerConstants.getImageIcon("SIPExport.png"));
        this.sipExportSubMenu.setToolTipText(I18N.translate((String)"ToolTipSIPExport"));
        this.sipExportSubMenu.add(new JMenuItem(this.exportAsSEDA21Action));
        this.sipExportSubMenu.add(new JMenuItem(this.exportAsSEDA1Action));
        this.reportsSubMenu = new JMenu(I18N.translate((String)"MenuReports"));
        this.reportsSubMenu.setIcon(PackerConstants.getImageIcon("Reports.png"));
        this.reportsSubMenu.setToolTipText(I18N.translate((String)"ToolTipReports"));
        String[] reports = new File(launcherView.getReportsDirectory()).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xsl");
            }
        });
        if (reports == null || reports.length == 0) {
            this.reportsSubMenu.setEnabled(false);
        } else {
            for (String report : reports) {
                final String reportName = report.substring(0, report.length() - 4);
                AbstractAction action = new AbstractAction(I18N.translate((String)reportName), PackerConstants.getImageIcon("Report.png")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SIPView.this.createReport(I18N.translate((String)reportName), reportName);
                    }
                };
                this.reportsSubMenu.add(new JMenuItem(action));
            }
        }
        this.fileMenu = new JMenu(I18N.translate((String)"MenuFile"));
        this.fileMenu.setName("SIP_VIEW_FILE_MENU");
        this.fileMenu.setIcon(PackerConstants.getImageIcon("MenuFile.png"));
        this.fileMenu.add(new JMenuItem(this.saveAction));
        JMenuItem saveAsMenuItem = new JMenuItem(this.saveAsAction);
        saveAsMenuItem.setName("SIP_VIEW_SAVE_AS_MENU_ITEM");
        this.fileMenu.add(saveAsMenuItem);
        JMenuItem saveAsTemplateMenuItem = new JMenuItem(this.saveAsTemplateAction);
        saveAsTemplateMenuItem.setName("SIP_VIEW_SAVE_AS_TEMPLATE_MENU_ITEM");
        this.fileMenu.add(saveAsTemplateMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(new JMenuItem(this.closeAction));
        this.fileMenu.addSeparator();
        JMenuItem importMetadataFromCSV = new JMenuItem(this.importMetadataFromCSVMenuAction);
        importMetadataFromCSV.setName("SIP_CSV_IMPORT_MENU_ITEM");
        this.fileMenu.add(importMetadataFromCSV);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.mdExportSubMenu);
        this.fileMenu.add(this.reportsSubMenu);
        this.fileMenu.add(this.sipExportSubMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(new JMenuItem(this.checkFixityAction));
        this.addMenuItem(this.fileMenu, this.exploreAction);
        this.fileMenu.addSeparator();
        JMenuItem removeDuplicatesMenuItem = new JMenuItem(this.removeDuplicatesAction);
        removeDuplicatesMenuItem.setName("SIP_VIEW_REMOVE_DUPLICATES_MENU_ITEM");
        this.fileMenu.add(removeDuplicatesMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(new JMenuItem(this.removeTrashAction));
        this.fileMenu.addSeparator();
        this.fileMenu.add(new JMenuItem(this.submitCheckAction));
        this.fileMenu.add(new JMenuItem(this.submitAction));
        this.searchMenu = new JMenu(I18N.translate((String)"MenuSearch"));
        this.searchMenu.setIcon(PackerConstants.getImageIcon("MenuSearch.png"));
        this.searchMenu.add(new JMenuItem(searchPanel.searchAction));
        this.searchMenu.add(new JMenuItem(searchPanel.clearSearchTextFieldAction));
        this.searchMenu.addSeparator();
        this.searchMenu.add(new JMenuItem(searchPanel.selectNextHitAction));
        this.searchMenu.add(new JMenuItem(searchPanel.selectPreviousHitAction));
        this.itemMenu = new JMenu(I18N.translate((String)"MenuItem"));
        this.itemMenu.setName("SIP_VIEW_ELEMENT_MENU");
        this.itemMenu.setIcon(PackerConstants.getImageIcon("MenuItem.png"));
        this.itemMenu.add(new JMenuItem(this.insertAction));
        JMenuItem createFolderMenuItem = new JMenuItem(this.createFolderAction);
        createFolderMenuItem.setName("SIP_VIEW_CREATE_FOLDER_MENU_ITEM");
        this.itemMenu.add(createFolderMenuItem);
        this.itemMenu.add(new JMenuItem(this.renameItemAction));
        this.itemMenu.add(new JMenuItem(this.sortAction));
        this.itemMenu.add(new JMenuItem(this.normalizeAction));
        this.itemMenu.addSeparator();
        this.itemMenu.add(new JMenuItem(this.replaceFileAction));
        this.itemMenu.add(new JMenuItem(this.appendMigratedFileAction));
        this.addMenuItem(this.itemMenu, this.convertAction);
        this.itemMenu.addSeparator();
        this.addMenuItem(this.itemMenu, this.deleteItemAction);
        this.addMenuItem(this.itemMenu, this.deleteItemDontAskAction);
        this.addMenuItem(this.itemMenu, this.deleteFileContentAction);
        if (launcherView.isActionVisible(this.deleteItemAction) || launcherView.isActionVisible(this.deleteItemDontAskAction) || launcherView.isActionVisible(this.deleteFileContentAction)) {
            this.itemMenu.addSeparator();
        }
        this.itemMenu.add(new JMenuItem(this.openAssignLevelsByLayerViewAction));
        this.itemMenu.add(new JMenuItem(this.openAssignLevelsByLabelViewAction));
        this.itemMenu.addSeparator();
        this.itemMenu.add(new JMenuItem(this.submitRequestAction));
        this.itemMenu.add(new JMenuItem(this.submitRetractAction));
        this.itemMenu.addSeparator();
        this.itemMenu.add(new JMenuItem(this.exportAction));
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new JMenuItem(this.insertAction));
        this.popupMenu.add(new JMenuItem(this.createFolderAction));
        JMenuItem renameMenuItem = new JMenuItem(this.renameItemAction);
        renameMenuItem.setName("SIP_VIEW_RENAME_FOLDER_MENU_ITEM");
        this.popupMenu.add(renameMenuItem);
        JMenuItem sortItem = new JMenuItem(this.sortAction);
        sortItem.setName("SIP_VIEW_SORT_FOLDER_MENU_ITEM");
        this.popupMenu.add(sortItem);
        this.popupMenu.add(this.normalizeAction);
        this.addMenuItem(this.popupMenu, this.importMetadataFromCSVContextAction, Optional.empty());
        this.popupMenu.addSeparator();
        JMenuItem replaceFileMenuItem = new JMenuItem(this.replaceFileAction);
        replaceFileMenuItem.setName("SIP_REPLACE_FILE_MENU_ITEM");
        this.popupMenu.add(replaceFileMenuItem);
        this.popupMenu.add(new JMenuItem(this.appendMigratedFileAction));
        this.addMenuItem(this.popupMenu, this.convertAction, Optional.empty());
        this.popupMenu.addSeparator();
        this.addMenuItem(this.popupMenu, this.deleteItemAction, Optional.of("SIP_DELETE_ITEM_MENU_ITEM"));
        this.addMenuItem(this.popupMenu, this.deleteItemDontAskAction, Optional.empty());
        this.addMenuItem(this.popupMenu, this.deleteFileContentAction, Optional.empty());
        if (launcherView.isActionVisible(this.deleteItemAction) || launcherView.isActionVisible(this.deleteItemDontAskAction) || launcherView.isActionVisible(this.deleteFileContentAction)) {
            this.popupMenu.addSeparator();
        }
        this.popupMenuStartOfLevelsSubMenu = this.popupMenu.getComponentCount();
        this.initializeLevelsSubMenu();
        this.saMenu = new JMenu(I18N.translate((String)"MenuSA"));
        this.saMenu.setIcon(PackerConstants.getImageIcon("MenuSA.png"));
        this.saMenu.add(new JMenuItem(this.openSAExternallyAction));
        this.saMenu.add(new JMenuItem(this.testOrAssignSAAction));
        this.viewMenu = new JMenu(I18N.translate((String)"MenuView"));
        this.viewMenu.setName("SIP_VIEW_MENU");
        this.viewMenu.setIcon(PackerConstants.getImageIcon("MenuView.png"));
        JMenuItem expandMenuItem = new JMenuItem(this.expandAllAction);
        expandMenuItem.setName("SIP_VIEW_EXPAND_MENU_ITEM");
        this.viewMenu.add(expandMenuItem);
        JMenuItem collapseMenuItem = new JMenuItem(this.collapseAllAction);
        collapseMenuItem.setName("SIP_VIEW_COLLAPSE_MENU_ITEM");
        this.viewMenu.add(collapseMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(new JMenuItem(this.redisplayNodeAction));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.fileMenu);
        menuBar.add(this.searchMenu);
        menuBar.add(this.itemMenu);
        menuBar.add(this.saMenu);
        menuBar.add(this.viewMenu);
        menuBar.setVisible(true);
        this.setJMenuBar(menuBar);
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        Box buttonsPanel = new Box(0);
        buttonsPanel.add(saveButton);
        buttonsPanel.add(Box.createHorizontalStrut(20));
        buttonsPanel.add(insertFileOrFolderButton);
        buttonsPanel.add(createFolderButton);
        buttonsPanel.add(renameItemButton);
        buttonsPanel.add(sortButton);
        buttonsPanel.add(normalizeButton);
        this.addButtonForAction(buttonsPanel, this.deleteItemAction);
        buttonsPanel.add(Box.createHorizontalStrut(20));
        buttonsPanel.add(this.infoLabel);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.logoButton);
        headerPanel.add((Component)buttonsPanel, "Center");
        JPanel mainLeftPanel = new JPanel(new BorderLayout());
        mainLeftPanel.add((Component)searchPanel, "North");
        mainLeftPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 5));
        mainLeftPanel.add((Component)new JScrollPane(this.treeTable), "Center");
        JPanel dataNorthPanel = new JPanel();
        dataNorthPanel.setLayout(new BoxLayout(dataNorthPanel, 1));
        dataNorthPanel.add(this.fileDataPropertiesLabel);
        dataNorthPanel.add(Box.createVerticalStrut(10));
        dataNorthPanel.add((Component)this.dataTable);
        dataNorthPanel.add(Box.createVerticalStrut(10));
        dataNorthPanel.add(this.fileDateEventsLabel);
        dataNorthPanel.add(Box.createVerticalStrut(10));
        JPanel dataSouthPanel = new JPanel();
        dataSouthPanel.setLayout(new BoxLayout(dataSouthPanel, 1));
        dataSouthPanel.add(Box.createVerticalStrut(10));
        dataSouthPanel.add(this.fileDataEventsDetailsLabel);
        dataSouthPanel.add(Box.createVerticalStrut(10));
        dataSouthPanel.add((Component)this.eventDetailTable);
        JPanel dataView = new JPanel(new BorderLayout());
        dataView.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        dataView.add((Component)dataNorthPanel, "North");
        dataView.add((Component)new JScrollPane(this.eventTable), "Center");
        dataView.add((Component)dataSouthPanel, "South");
        GridBagPanel metadataNorthPanel = new GridBagPanel((Border)new EmptyBorder(10, 0, 10, 0), new Insets(0, 5, 0, 0));
        metadataNorthPanel.add((Component)new JLabel(I18N.translate((String)"LabelTitle")), 1, 0, 17);
        metadataNorthPanel.add((Component)this.metaTitleTextField, 1, 1, 17, 2, 1.0, 0.0);
        metadataNorthPanel.add((Component)new JLabel(I18N.translate((String)"LabelLevel")), 2, 0, 17);
        metadataNorthPanel.add((Component)this.metaLevelTextField, 2, 1, 17, 2, 1.0, 0.0);
        GridBagPanel metadataSouthPanel = new GridBagPanel((Border)new EmptyBorder(0, 0, 0, 0), new Insets(5, 0, 0, 0));
        metadataSouthPanel.add((Component)new JLabel(I18N.translate((String)"LabelSelectMetadataElement")), 1, 1, 0, 3, 16);
        metadataSouthPanel.add(this.selectMetadataElementComboBox, 2, 0, 16);
        metadataSouthPanel.add((Component)insertMetadataElementButton, 2, 1, 16);
        metadataSouthPanel.add((Component)new JLabel(), 2, 2, 16, 2, 1.0, 0.0);
        metadataSouthPanel.add((Component)removeMetadataElementButton, 2, 3, 14);
        JPanel metadataView = new JPanel(new BorderLayout());
        metadataView.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        metadataView.add((Component)metadataNorthPanel, "North");
        this.metadataTableScrollPane = new JScrollPane((Component)((Object)this.metadataTable));
        this.metadataTableScrollPane.setWheelScrollingEnabled(true);
        this.metadataTableScrollPane.setAutoscrolls(true);
        metadataView.add((Component)this.metadataTableScrollPane, "Center");
        metadataView.add((Component)metadataSouthPanel, "South");
        this.previewPanel = new FilePreviewer();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SIPView.this.previewSelectedItemIfNecessary();
            }
        });
        this.tabbedPane.addTab(I18N.translate((String)"TitleFileData"), null, dataView);
        this.tabbedPane.addTab(I18N.translate((String)"TitleMetadata"), null, metadataView);
        this.tabbedPane.addTab(I18N.translate((String)"TitleFilePreview"), null, this.previewPanel);
        JPanel mainRightPanel = new JPanel(new BorderLayout());
        mainRightPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
        mainRightPanel.add(this.tabbedPane);
        this.splitPane = new JSplitPane(1, true, mainLeftPanel, mainRightPanel);
        JPanel footerPanel = new JPanel(new BorderLayout());
        footerPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        footerPanel.add(this.footerTextField);
        this.add((Component)headerPanel, "North");
        this.add((Component)this.splitPane, "Center");
        this.add((Component)footerPanel, "South");
        this.setName("SIP_VIEW_FRAME");
    }

    private void addButtonForAction(Box buttonsPanel, Action action) {
        if (this.launcherView.isActionVisible(action)) {
            JButton button = new JButton(action);
            button.setHideActionText(true);
            button.setRequestFocusEnabled(false);
            buttonsPanel.add(button);
        }
    }

    private void addMenuItem(JMenu itemMenu, Action action) {
        if (this.launcherView.isActionVisible(action)) {
            itemMenu.add(new JMenuItem(action));
        }
    }

    private void addMenuItem(JPopupMenu itemMenu, Action action, Optional<String> name) {
        if (this.launcherView.isActionVisible(action)) {
            JMenuItem jMenuItem = new JMenuItem(action);
            if (name.isPresent()) {
                jMenuItem.setName(name.get());
            }
            itemMenu.add(jMenuItem);
        }
    }

    public LauncherView getLauncherView() {
        return this.launcherView;
    }

    public JXTreeTable getTreeTable() {
        return this.treeTable;
    }

    public NodeAbstract getSelectedNode() {
        return this.selectedNode;
    }

    public static SIPView open(LauncherView launcherView, FileProperty fileProperty, Document.Mode mode, String admIdToSelect) {
        SIPView sipView = new SIPView(launcherView);
        sipView.fileProperty = fileProperty;
        if (openFullScreen.booleanValue()) {
            sipView.setLocation(0, 0);
            sipView.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        } else {
            sipView.setPreferredSize(new Dimension(screenSizeX, screenSizeY));
            sipView.pack();
            if (screenPosX != null && screenPosY != null) {
                sipView.setLocation(screenPosX, screenPosY);
            } else {
                sipView.setLocationRelativeTo(null);
            }
        }
        sipView.setDividerLocation(sipView.getWidth() / 2);
        sipView.treeTable.requestFocusInWindow();
        sipView.setVisible(true);
        if (fileProperty.getFile().getName().toLowerCase().endsWith(".zip")) {
            sipView.read(fileProperty.getFile().getAbsolutePath(), mode, admIdToSelect);
        } else {
            sipView.read(fileProperty.getFile().getAbsolutePath() + "/mets.xml", mode, admIdToSelect);
        }
        return sipView;
    }

    public static void initialize(Properties propertiesIn) {
        properties = propertiesIn;
        saveWithBackups = Boolean.parseBoolean(properties.getProperty("docuteamPacker.versioning", "true"));
        Logger.info((Object)("    saveWithBackups: " + saveWithBackups));
        try {
            Document.setKeepBackupsCount(new Integer(properties.getProperty("docuteamPacker.versioning.keepBackupsCount")));
        }
        catch (NumberFormatException e) {
            Document.setKeepBackupsCount(null);
        }
        Logger.info((Object)("    keepBackupsCount: " + Document.getKeepBackupsCount()));
        openFullScreen = Boolean.parseBoolean(properties.getProperty("docuteamPacker.openFullScreen", openFullScreen.toString()));
        try {
            screenSizeX = new Integer(properties.getProperty("docuteamPacker.screenSize.x", screenSizeX.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            screenSizeY = new Integer(properties.getProperty("docuteamPacker.screenSize.y", screenSizeY.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            screenPosX = new Integer(properties.getProperty("docuteamPacker.screenPos.x"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            screenPosY = new Integer(properties.getProperty("docuteamPacker.screenPos.y"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Logger.info((Object)("    openFullScreen: " + openFullScreen));
        Logger.info((Object)("    ScreenSizeX: " + screenSizeX));
        Logger.info((Object)("    ScreenSizeY: " + screenSizeY));
        Logger.info((Object)("    ScreenPosX: " + screenPosX));
        Logger.info((Object)("    ScreenPosY: " + screenPosY));
    }

    public Document getDocument() {
        return this.document;
    }

    public FileProperty getFileProperty() {
        return this.fileProperty;
    }

    protected void initializeLevelsSubMenu() {
        if (this.itemLevelsSubMenu != null) {
            this.itemMenu.remove(this.itemLevelsSubMenu);
        }
        for (int i = this.popupMenu.getComponentCount(); i > this.popupMenuStartOfLevelsSubMenu; --i) {
            this.popupMenu.remove(i - 1);
        }
        this.setLevelActions = new Vector<Action>(10);
        this.itemLevelsSubMenu = new JMenu(I18N.translate((String)"MenuLevels"));
        this.itemLevelsSubMenu.setIcon(PackerConstants.getImageIcon("AssignLevel.png"));
        if (this.document != null) {
            for (LevelOfDescription level : this.document.getLevels().getAll()) {
                ImageIcon icon = level.getIcon() != null ? level.getIcon() : PackerConstants.ICON_LEVEL_UNKNOWN;
                AbstractAction action = new AbstractAction(level.getName(), icon){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SIPView.this.setLevelButtonClicked(e);
                    }
                };
                this.setLevelActions.add(action);
                this.itemLevelsSubMenu.add(new JMenuItem(action));
                this.popupMenu.add(new JMenuItem(action));
            }
        }
        this.itemMenu.add((Component)this.itemLevelsSubMenu, this.popupMenuStartOfLevelsSubMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.submitRequestAction));
        this.popupMenu.add(new JMenuItem(this.submitRetractAction));
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.treeTable.getTreeTableModel();
    }

    public void read(final String zipOrMETSFilePath, final Document.Mode mode, final String admIdToSelect) {
        new SwingWorker<Integer, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public Integer doInBackground() {
                block40: {
                    SmallPeskyMessageWindow waitWindow;
                    String canonicalZIPOrMETSFileName;
                    block39: {
                        block36: {
                            canonicalZIPOrMETSFileName = FileUtil.asCanonicalFileName((String)zipOrMETSFilePath);
                            SIPView.this.setFooterText(I18N.translate((String)"MessageFooterOpeningFile") + canonicalZIPOrMETSFileName + "...");
                            waitWindow = SmallPeskyMessageWindow.openBlocking((Window)SIPView.this, (String)I18N.translate((String)"MessageTempReadingSIP"));
                            SIPView.this.setCursor(Cursor.getPredefinedCursor(3));
                            ExceptionCollector.clear();
                            switch (mode) {
                                case ReadWrite: {
                                    SIPView.this.document = Document.openReadWrite(canonicalZIPOrMETSFileName, "docuteam packer", (Observer)waitWindow);
                                    break;
                                }
                                case ReadWriteNoFileOps: {
                                    SIPView.this.document = Document.openReadWriteFilesLocked(canonicalZIPOrMETSFileName, "docuteam packer", (Observer)waitWindow);
                                    break;
                                }
                                case ReadOnly: {
                                    SIPView.this.document = Document.openReadOnly(canonicalZIPOrMETSFileName, "docuteam packer", (Observer)waitWindow);
                                    break;
                                }
                                case Locked: {
                                    break;
                                }
                                case Undefined: {
                                    break;
                                }
                            }
                            SIPView.this.setFooterText(canonicalZIPOrMETSFileName);
                            SIPView.this.setTitle(canonicalZIPOrMETSFileName);
                            if (!ExceptionCollector.isEmpty().booleanValue()) {
                                waitWindow.close();
                                new ScrollableMessageDialog((Window)SIPView.this, I18N.translate((String)"TitleWarningsOccurred"), ExceptionCollector.getAllTranslatedMessages((String)"NoExceptionMessage", (String)"ExceptionMessagePrefix"), PackerConstants.getImageIcon("DocuteamPacker.png"));
                            }
                            if (SIPView.this.document != null) break block36;
                            SIPView.this.closeButtonClicked();
                            break block39;
                        }
                        SIPView.this.populateView(SIPView.this.document);
                    }
                    waitWindow.close();
                    SIPView.this.setCursor(Cursor.getPredefinedCursor(0));
                    SIPView.this.toFront();
                    SIPView.this.requestFocus();
                    try {
                        if (Boolean.valueOf(properties.getProperty("docuteamPacker.SIPView.TreeExpandAll", "false")).booleanValue()) {
                            SIPView.this.expandAll();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    SIPView.this.selectNode(admIdToSelect);
                    int selectedTab = 0;
                    try {
                        selectedTab = Integer.valueOf(properties.getProperty("docuteamPacker.SIPView.DefaultTab", "1")) - 1;
                        selectedTab = selectedTab >= 0 && selectedTab <= 2 ? selectedTab : 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    SIPView.this.tabbedPane.setSelectedIndex(selectedTab);
                    break block40;
                    catch (ZIPDoesNotContainMETSFileException e2222222222) {
                        block41: {
                            block37: {
                                SIPView.this.document = null;
                                SIPView.this.setFooterText(I18N.translate((String)"MessageFooterCantCreateFile") + canonicalZIPOrMETSFileName);
                                SIPView.this.setTitle(DefaultFrameTitle);
                                waitWindow.close();
                                JOptionPane.showMessageDialog(SIPView.this, e2222222222.toString(), I18N.translate((String)"TitleCantReadSIP"), 0);
                                if (SIPView.this.document != null) break block37;
                                SIPView.this.closeButtonClicked();
                                break block41;
                            }
                            SIPView.this.populateView(SIPView.this.document);
                        }
                        waitWindow.close();
                        SIPView.this.setCursor(Cursor.getPredefinedCursor(0));
                        SIPView.this.toFront();
                        SIPView.this.requestFocus();
                        try {
                            if (Boolean.valueOf(properties.getProperty("docuteamPacker.SIPView.TreeExpandAll", "false")).booleanValue()) {
                                SIPView.this.expandAll();
                            }
                        }
                        catch (NumberFormatException e2222222222) {
                            // empty catch block
                        }
                        SIPView.this.selectNode(admIdToSelect);
                        selectedTab = 0;
                        try {
                            selectedTab = Integer.valueOf(properties.getProperty("docuteamPacker.SIPView.DefaultTab", "1")) - 1;
                            selectedTab = selectedTab >= 0 && selectedTab <= 2 ? selectedTab : 0;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        SIPView.this.tabbedPane.setSelectedIndex(selectedTab);
                    }
                    catch (java.lang.Exception e3222222222) {
                        block42: {
                            block38: {
                                Logger.error((Object)e3222222222.getMessage(), (Throwable)e3222222222);
                                SIPView.this.document = null;
                                SIPView.this.setFooterText(I18N.translate((String)"MessageFooterCantCreateFile") + canonicalZIPOrMETSFileName);
                                SIPView.this.setTitle(DefaultFrameTitle);
                                waitWindow.close();
                                JOptionPane.showMessageDialog(SIPView.this, e3222222222.toString(), I18N.translate((String)"TitleCantReadSIP"), 0);
                                if (SIPView.this.document != null) break block38;
                                SIPView.this.closeButtonClicked();
                                {
                                    catch (Throwable throwable) {
                                        if (SIPView.this.document == null) {
                                            SIPView.this.closeButtonClicked();
                                        } else {
                                            SIPView.this.populateView(SIPView.this.document);
                                        }
                                        waitWindow.close();
                                        SIPView.this.setCursor(Cursor.getPredefinedCursor(0));
                                        SIPView.this.toFront();
                                        SIPView.this.requestFocus();
                                        try {
                                            if (Boolean.valueOf(properties.getProperty("docuteamPacker.SIPView.TreeExpandAll", "false")).booleanValue()) {
                                                SIPView.this.expandAll();
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        SIPView.this.selectNode(admIdToSelect);
                                        int selectedTab2 = 0;
                                        try {
                                            selectedTab2 = Integer.valueOf(properties.getProperty("docuteamPacker.SIPView.DefaultTab", "1")) - 1;
                                            selectedTab2 = selectedTab2 >= 0 && selectedTab2 <= 2 ? selectedTab2 : 0;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        SIPView.this.tabbedPane.setSelectedIndex(selectedTab2);
                                        throw throwable;
                                    }
                                }
                                break block42;
                            }
                            SIPView.this.populateView(SIPView.this.document);
                        }
                        waitWindow.close();
                        SIPView.this.setCursor(Cursor.getPredefinedCursor(0));
                        SIPView.this.toFront();
                        SIPView.this.requestFocus();
                        try {
                            if (Boolean.valueOf(properties.getProperty("docuteamPacker.SIPView.TreeExpandAll", "false")).booleanValue()) {
                                SIPView.this.expandAll();
                            }
                        }
                        catch (NumberFormatException e3222222222) {
                            // empty catch block
                        }
                        SIPView.this.selectNode(admIdToSelect);
                        selectedTab = 0;
                        try {
                            selectedTab = Integer.valueOf(properties.getProperty("docuteamPacker.SIPView.DefaultTab", "1")) - 1;
                            selectedTab = selectedTab >= 0 && selectedTab <= 2 ? selectedTab : 0;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        SIPView.this.tabbedPane.setSelectedIndex(selectedTab);
                    }
                }
                return 0;
            }
        }.execute();
    }

    protected void saveCopyAs(final String filePath, final boolean doUnlockAndCleanupAfterwards) {
        if (this.document == null) {
            return;
        }
        if (!this.document.canWrite()) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageIsReadOnlyCantSave"), I18N.translate((String)"TitleCantSaveSIP"), 0);
            return;
        }
        new SwingWorker<Integer, Object>(){

            @Override
            public Integer doInBackground() {
                SmallPeskyMessageWindow waitWindow = SmallPeskyMessageWindow.openBlocking((Window)SIPView.this, (String)I18N.translate((String)"MessageTempSavingSIP"));
                try {
                    SIPView.this.setCursor(Cursor.getPredefinedCursor(3));
                    SIPView.this.launcherView.savingDocumentInProgress(SIPView.this);
                    SIPView.this.saveSIP(filePath, doUnlockAndCleanupAfterwards);
                    SIPView.this.setFooterText(I18N.translate((String)"MessageFooterSaved") + SIPView.this.document.getFilePath());
                    SIPView.this.setTitle(SIPView.this.document.getOriginalSIPFolder());
                }
                catch (FileOrFolderIsInUseException e) {
                    waitWindow.close();
                    JOptionPane.showMessageDialog(SIPView.this, I18N.translate((String)"MessageFileOrFolderIsInUseException", (Object[])new Object[]{e.getOriginalSIPName(), e.getSecurityCopySIPName(), FileUtil.asFileName((String)e.getOriginalSIPName()), FileUtil.asFileName((String)e.getSecurityCopySIPName())}), I18N.translate((String)"TitleCantSaveSIP"), 0);
                }
                catch (OriginalSIPIsMissingException e) {
                    waitWindow.close();
                    JOptionPane.showMessageDialog(SIPView.this, I18N.translate((String)"MessageOriginalSIPIsMissingException", (Object[])new Object[]{e.getOriginalSIPFolderPath()}), I18N.translate((String)"TitleCantCopySIP"), 2);
                }
                catch (java.lang.Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                    waitWindow.close();
                    JOptionPane.showMessageDialog(SIPView.this, e.toString(), I18N.translate((String)"TitleCantSaveSIP"), 0);
                    SIPView.this.setFooterText(I18N.translate((String)"MessageFooterCantSave") + SIPView.this.document.getFilePath());
                }
                finally {
                    SIPView.this.launcherView.savingDocumentFinished(SIPView.this);
                    waitWindow.close();
                    SIPView.this.setCursor(Cursor.getPredefinedCursor(0));
                    SIPView.this.enableOrDisableActions();
                    SIPView.this.toFront();
                    SIPView.this.treeTable.requestFocus();
                }
                return 0;
            }
        }.execute();
    }

    private void saveSIP(String filePath, boolean doUnlockAndCleanupAfterwards) throws IOException, FileUtilExceptionListException, DocumentIsReadOnlyException, FileOrFolderIsInUseException, OriginalSIPIsMissingException {
        if (filePath == null || filePath.isEmpty()) {
            Logger.debug((Object)"Saving document");
            if (saveWithBackups) {
                this.document.saveWithBackup();
            } else {
                this.document.saveWithoutBackup();
            }
        } else {
            Logger.debug((Object)("Saving document as: " + filePath));
            this.document.saveTo(filePath);
        }
        this.launcherView.getSipTable().rereadSIPTable();
        if (doUnlockAndCleanupAfterwards) {
            try {
                this.document.unlockIfNecessary();
                this.document.cleanupWorkingCopy();
            }
            catch (java.lang.Exception e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
                JOptionPane.showMessageDialog(this, e.toString(), "Unable to cleanup working folder due to errors", 0);
            }
        }
    }

    protected void previewSelectedItemIfNecessary() {
        if (this.tabbedPane.getSelectedIndex() != 2 && !this.previewPanel.isPreviewInSeparateWindow()) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.previewPanel.setNode(this.selectedNode);
        }
        finally {
            this.previewPanel.validate();
            this.previewPanel.repaint();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void importFilesAndFolders(final List<File> files) {
        new SwingWorker<Integer, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInBackground() {
                SmallPeskyMessageWindow waitWindow = SmallPeskyMessageWindow.openBlocking((Window)SIPView.this, (String)I18N.translate((String)"MessageTempInsertingFolder"));
                try {
                    SIPView.this.setCursor(Cursor.getPredefinedCursor(3));
                    NodeAbstract lastInsertedNode = null;
                    try {
                        ExceptionCollector.clear();
                        for (File f : files) {
                            Logger.debug((Object)("Inserting: " + f));
                            String filePath = f.getPath();
                            lastInsertedNode = ((NodeFolder)SIPView.this.selectedNode).insertFileOrFolder(filePath);
                        }
                        Util.showAllFromExceptionCollector(waitWindow, SIPView.this);
                    }
                    catch (java.lang.Exception e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                        waitWindow.close();
                        JOptionPane.showMessageDialog(SIPView.this, e.toString(), I18N.translate((String)"TitleCantInsertFileOrFolder"), 0);
                    }
                    SIPView.this.getTreeTableModel().refreshTreeStructure(SIPView.this.treeTable.getPathForRow(SIPView.this.selectedIndex));
                    SIPView.this.selectNode(lastInsertedNode);
                    SIPView.this.toFront();
                    SIPView.this.requestFocus();
                }
                finally {
                    waitWindow.close();
                    SIPView.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                return 0;
            }
        }.execute();
    }

    public void populateView(Document documentOrNull) {
        this.initializeLevelsSubMenu();
        this.treeTable.setTreeTableModel(new TreeTableModel(documentOrNull));
        this.treeTable.getSelectionModel().addSelectionInterval(0, 0);
    }

    public void setFooterText(String text) {
        this.setFooterText(text, false);
    }

    protected void setFooterText(String text, boolean isEmphasized) {
        this.footerTextField.setForeground(isEmphasized ? Color.RED : Color.BLACK);
        this.footerTextField.setText(text);
    }

    protected void collapseCurrentNode() {
        this.treeTable.collapseRow(this.treeTable.getSelectedRow());
    }

    protected void expandCurrentNode() {
        this.treeTable.expandRow(this.treeTable.getSelectedRow());
    }

    protected void treeViewSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.metadataTable.commitOrCancelCurrentCellEditor();
        this.selectedIndex = this.treeTable.getSelectedRow();
        this.selectedNode = null;
        if (this.treeTable.getSelectedRowCount() == 0) {
            Logger.debug((Object)("No Selection: " + this.selectedIndex));
            this.setFooterText("");
            this.updateView();
            this.previewSelectedItemIfNecessary();
            return;
        }
        if (this.treeTable.getSelectedRowCount() >= 2) {
            StringBuilder footerText = new StringBuilder();
            for (int i : this.treeTable.getSelectedRows()) {
                footerText.append(", ").append(((NodeAbstract)this.treeTable.getPathForRow(i).getLastPathComponent()).getLabel());
            }
            this.setFooterText(footerText.substring(2));
            Logger.debug((Object)("Multiple selection: " + this.selectedIndex + ": " + this.footerTextField.getText()));
            this.clearView();
            this.previewSelectedItemIfNecessary();
            return;
        }
        TreePath pathForSelectedRow = this.treeTable.getPathForRow(this.selectedIndex);
        if (pathForSelectedRow == null) {
            Logger.debug((Object)("PathForSelectedRow is null: " + this.selectedIndex));
            this.setFooterText("");
            this.clearView();
            this.previewSelectedItemIfNecessary();
            return;
        }
        this.selectedNode = (NodeAbstract)pathForSelectedRow.getLastPathComponent();
        Logger.debug((Object)("Selected Node: " + this.selectedIndex + ": " + this.selectedNode));
        this.setFooterText(this.selectedNode.getPathString() + (this.selectedNode.isFolder() ? "/" : ""));
        this.updateView();
        this.fillInsertMetadataElementComboBox();
        this.previewSelectedItemIfNecessary();
        int eventsSize = this.selectedNode.getMyEvents().size();
        if (eventsSize > 0) {
            this.eventTable.getSelectionModel().setSelectionInterval(eventsSize - 1, eventsSize - 1);
        }
    }

    protected void treeViewSelectionWasClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.previewPanel.openFileExternallyButtonClicked(this.selectedNode);
        } else if (e.getButton() == 3) {
            int rowNumber = this.treeTable.rowAtPoint(e.getPoint());
            boolean isSelected = false;
            for (int i : this.treeTable.getSelectedRows()) {
                if (i != rowNumber) continue;
                isSelected = true;
            }
            if (!isSelected) {
                this.treeTable.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
            }
            this.popupMenu.show(this.treeTable, e.getX(), e.getY());
        }
    }

    protected void eventTableSelectionChanged(ListSelectionEvent e) {
        Integer selectedEventIndex = ((ListSelectionModel)e.getSource()).getLeadSelectionIndex();
        NodeAbstract listTableModel = ((EventListTableModel)this.eventTable.getModel()).getFileStructureNode();
        if (listTableModel == null || selectedEventIndex < 0 || selectedEventIndex >= listTableModel.getMyEvents().size()) {
            ((EventDetailTableModel)this.eventDetailTable.getModel()).setEvent(null);
        } else {
            Event selectedEvent = listTableModel.getMyEvent(selectedEventIndex);
            ((EventDetailTableModel)this.eventDetailTable.getModel()).setEvent(selectedEvent);
        }
    }

    protected void metadataTableSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableOrDisableActions();
        this.scrollToSelectedRow();
    }

    private void scrollToSelectedRow() {
        try {
            int row = this.metadataTable.getSelectedRow();
            Rectangle rect = this.metadataTable.getCellRect(row, 0, true);
            Point pt = this.metadataTableScrollPane.getViewport().getViewPosition();
            rect.translate(-pt.x, -pt.y);
            this.metadataTableScrollPane.getViewport().scrollRectToVisible(rect);
        }
        catch (java.lang.Exception exception) {
            // empty catch block
        }
    }

    public boolean closeButtonClicked() {
        if (!this.isEnabled()) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantCloseSIP"), I18N.translate((String)"TitleCloseSIP"), 0);
            return false;
        }
        if (this.document != null) {
            boolean doUnlockAndCleanupAfterwards = true;
            this.flushCurentEditing();
            if (this.document.isModified()) {
                int answer = JOptionPane.showConfirmDialog(this, "'" + this.document.getSIPName() + "':\n" + I18N.translate((String)"QuestionSaveModified"), I18N.translate((String)"TitleCloseSIP"), 1, 3);
                switch (answer) {
                    case 0: {
                        doUnlockAndCleanupAfterwards = false;
                        this.saveCopyAs(null, true);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (doUnlockAndCleanupAfterwards) {
                try {
                    this.document.unlockIfNecessary();
                    this.document.cleanupWorkingCopy();
                }
                catch (java.lang.Exception e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                    JOptionPane.showMessageDialog(this, e.toString(), "Unable to cleanup working folder due to errors", 0);
                }
            }
        }
        this.launcherView.unregister(this);
        this.setVisible(false);
        this.dispose();
        return true;
    }

    protected void flushCurentEditing() {
        if (this.metaTitleTextField.isFocusOwner()) {
            this.metaTitleTextFieldWasChanged();
        }
        this.metadataTable.commitOrCancelCurrentCellEditor();
    }

    protected void saveButtonClicked(ActionEvent actionEvent) {
        this.flushCurentEditing();
        if ((actionEvent.getModifiers() & 1) != 0) {
            this.saveAsButtonClicked();
        } else {
            this.saveCopyAs(null, false);
        }
    }

    protected void saveAsButtonClicked() {
        File selectedFile;
        this.flushCurentEditing();
        JFileChooser fileChooser = new JFileChooser(this.launcherView.getLastUsedOpenOrSaveDirectory());
        fileChooser.setDialogType(1);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleSaveSIPAs"));
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(false);
        File suggestedFile = this.getFileProperty().getFile();
        while (true) {
            fileChooser.setSelectedFile(suggestedFile);
            int answer = fileChooser.showSaveDialog(this);
            if (1 == answer) {
                return;
            }
            selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.exists()) break;
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageNameAlreadyExists", (Object[])new Object[]{selectedFile.getName(), selectedFile.getParentFile()}), I18N.translate((String)"TitleCantCopySIP"), 2);
        }
        this.saveCopyAs(selectedFile.getPath(), false);
    }

    protected void insertFileOrFolderButtonClicked() {
        JFileChooser fileChooser = new JFileChooser(this.launcherView.getDataDirectory());
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        if (fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.launcherView.setDataDirectory(FileUtil.asCanonicalFileName((String)fileChooser.getSelectedFile().getParent()));
        if (this.launcherView.getDataDirectory().isEmpty()) {
            this.launcherView.setDataDirectory(FileUtil.asCanonicalFileName((String)OperatingSystem.userHome()));
        }
        this.importFilesAndFolders(Arrays.asList(fileChooser.getSelectedFiles()));
    }

    protected void createFolderButtonClicked() {
        Boolean ok;
        String title = I18N.translate((String)"TitleNewFolder");
        Object message = I18N.translate((String)"MessageEnterNewFolderName");
        String textFieldContent = "";
        int messageType = 3;
        NodeFolder newFolder = null;
        do {
            String newFolderName;
            if ((newFolderName = (String)new ElementNamingDialog().showInputDialog(this, message, title, messageType, null, null, textFieldContent, 540, 150)) == null) {
                return;
            }
            if ((newFolderName = newFolderName.trim()).length() == 0) {
                return;
            }
            ok = false;
            if (!FileUtil.isFileNameAllowed((String)newFolderName)) {
                title = I18N.translate((String)"TitleCantCreateNewFolder");
                message = I18N.translate((String)"MessageBadLettersInFilename") + "\n" + I18N.translate((String)"MessageEnterNewFolderName");
                messageType = 2;
                textFieldContent = newFolderName;
                continue;
            }
            try {
                newFolder = ((NodeFolder)this.selectedNode).createNewFolder(newFolderName);
            }
            catch (FileAlreadyExistsException ex) {
                title = I18N.translate((String)"TitleCantCreateNewFolder");
                message = I18N.translate((String)"MessageNameAlreadyExists", (Object[])new Object[]{newFolderName, this.selectedNode.getLabel()}) + "\n" + I18N.translate((String)"MessageEnterNewFolderName");
                messageType = 2;
                textFieldContent = newFolderName;
                continue;
            }
            catch (java.lang.Exception ex) {
                title = I18N.translate((String)"TitleCantCreateNewFolder");
                message = ex.getMessage() + "\n" + I18N.translate((String)"MessageEnterNewFolderName");
                messageType = 2;
                textFieldContent = newFolderName;
                continue;
            }
            ok = true;
        } while (!ok.booleanValue());
        this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(this.selectedIndex));
        this.selectNode(newFolder);
    }

    protected void normalizeButtonClicked() {
        int answer = JOptionPane.showConfirmDialog(this, I18N.translate((String)"QuestionNormalizeAll"), I18N.translate((String)"TitleQuestionNormalizeAll"), 0, 3);
        if (answer == 0) {
            new SwingWorker<Map<List<NodeAbstract>, List<NodeAbstract>>, Object>(){
                Map<List<NodeAbstract>, List<NodeAbstract>> resultMap = new HashMap<List<NodeAbstract>, List<NodeAbstract>>();

                @Override
                public Map<List<NodeAbstract>, List<NodeAbstract>> doInBackground() {
                    SIPView.this.setCursor(Cursor.getPredefinedCursor(3));
                    int selectedRowCount = SIPView.this.treeTable.getSelectedRowCount();
                    FileNameNormalizer fileNameNormalizer = new FileNameNormalizer(SIPView.this.launcherView.getConfigDirectory());
                    if (selectedRowCount == 1 && SIPView.this.selectedNode != null) {
                        int selRow = SIPView.this.treeTable.getSelectedRow();
                        this.resultMap = fileNameNormalizer.normalizeFilesAndFolderNamesAndRename(SIPView.this.selectedNode);
                        SIPView.this.getTreeTableModel().refreshTreeStructure(SIPView.this.treeTable.getPathForRow(selRow).getParentPath());
                    } else if (selectedRowCount > 1) {
                        int[] selectedRows = SIPView.this.treeTable.getSelectedRows();
                        ArrayList<NodeAbstract> selectedNodes = new ArrayList<NodeAbstract>();
                        for (int selectedRow : selectedRows) {
                            NodeAbstract node = (NodeAbstract)SIPView.this.treeTable.getPathForRow(selectedRow).getLastPathComponent();
                            selectedNodes.add(node);
                        }
                        this.resultMap = fileNameNormalizer.normalizeFilesAndFolderNamesAndRename(selectedNodes);
                        for (int selectedRow : selectedRows) {
                            SIPView.this.getTreeTableModel().refreshTreeStructure(SIPView.this.treeTable.getPathForRow(selectedRow).getParentPath());
                        }
                    }
                    return this.resultMap;
                }

                @Override
                protected void done() {
                    SIPView.this.setCursor(Cursor.getPredefinedCursor(0));
                    ArrayList<NodeAbstract> renamedNodes = new ArrayList<NodeAbstract>();
                    ArrayList notNormalizedNodes = new ArrayList();
                    for (List<NodeAbstract> nextKey : this.resultMap.keySet()) {
                        renamedNodes.addAll(nextKey);
                        notNormalizedNodes.addAll(this.resultMap.get(nextKey));
                    }
                    ArrayList<CallSite> notNormalizedLabels = new ArrayList<CallSite>();
                    String[] bigGUIList = new String[30];
                    for (NodeAbstract node : notNormalizedNodes) {
                        String label = node.getPathString() + " => " + node.getLabel();
                        notNormalizedLabels.add((CallSite)((Object)label));
                    }
                    if (notNormalizedLabels.size() > 0) {
                        JOptionPane.showInputDialog(SIPView.this.splitPane, I18N.translate((String)"MessageCannotNormalize"), I18N.translate((String)"MessageNormalizeAllSuccessful", (Object[])new Object[]{renamedNodes.size()}), 1, null, notNormalizedLabels.toArray(bigGUIList), null);
                    } else {
                        JOptionPane.showMessageDialog(SIPView.this.splitPane, I18N.translate((String)"MessageNormalizeAllSuccessful", (Object[])new Object[]{renamedNodes.size()}));
                    }
                }
            }.execute();
        }
    }

    protected void renameItemButtonClicked() {
        Boolean ok;
        String title = I18N.translate((String)"TitleRenameItem");
        Object message = I18N.translate((String)"MessageEnterNewItemName");
        String textFieldContent = this.selectedNode.getLabel().trim();
        int messageType = 3;
        do {
            String newItemName;
            if ((newItemName = (String)new ElementNamingDialog().showInputDialog(this, message, title, messageType, null, null, textFieldContent, 540, 150)) == null) {
                return;
            }
            if ((newItemName = newItemName.trim()).length() == 0) {
                return;
            }
            ok = false;
            if (!FileUtil.isFileNameAllowed((String)newItemName)) {
                title = I18N.translate((String)"TitleCantRenameItem");
                message = I18N.translate((String)"MessageBadLettersInFilename") + "\n" + I18N.translate((String)"MessageEnterNewItemName");
                messageType = 2;
                textFieldContent = newItemName;
                continue;
            }
            try {
                this.selectedNode.rename(newItemName);
            }
            catch (java.lang.Exception ex) {
                title = I18N.translate((String)"TitleCantRenameItem");
                message = ex.getMessage() + "\n" + I18N.translate((String)"MessageEnterNewItemName");
                messageType = 2;
                textFieldContent = this.selectedNode.getLabel();
                continue;
            }
            ok = true;
        } while (!ok.booleanValue());
        this.getTreeTableModel().refreshNode(this.treeTable.getPathForRow(this.selectedIndex));
        this.enableOrDisableActions();
        this.updateView();
        int lastEventIndex = this.selectedNode.getMyEvents().size() - 1;
        this.eventTable.getSelectionModel().setSelectionInterval(lastEventIndex, lastEventIndex);
    }

    protected void deleteItemButtonClicked(ActionEvent actionEvent) {
        if ((actionEvent.getModifiers() & 1) == 0) {
            int selectedRowCount = this.treeTable.getSelectedRowCount();
            if (selectedRowCount == 0) {
                return;
            }
            if (selectedRowCount == 1 ? (this.selectedNode.isFolder() && this.selectedNode.getChildCount() != 0 ? JOptionPane.showConfirmDialog(this, I18N.translate((String)"QuestionDeleteWithAllSubElements"), I18N.translate((String)"TitleDeleteFolder"), 0) != 0 : JOptionPane.showConfirmDialog(this, I18N.translate((String)"QuestionDeleteItem"), I18N.translate((String)"TitleDeleteItem"), 0) != 0) : JOptionPane.showConfirmDialog(this, I18N.translate((String)"QuestionDeleteMultipleItems", (Object[])new Object[]{selectedRowCount}), I18N.translate((String)"TitleDeleteMultipleItems"), 0) != 0) {
                return;
            }
        }
        this.deleteItemDontAskButtonClicked();
    }

    public void deleteItemDontAskButtonClicked() {
        int selectedRowCount = this.treeTable.getSelectedRowCount();
        if (selectedRowCount == 0) {
            return;
        }
        if (selectedRowCount == 1) {
            if (this.selectedNode.isRoot().booleanValue()) {
                JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantDeleteRootItem"), I18N.translate((String)"TitleCantDeleteItem"), 2);
                return;
            }
            try {
                this.selectedNode.delete();
            }
            catch (FileOperationNotAllowedException ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (java.lang.Exception e) {
                JOptionPane.showMessageDialog(this, e.toString(), I18N.translate((String)"TitleCantDeleteItem"), 0);
            }
            this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(this.selectedIndex).getParentPath());
        } else {
            for (int i : this.treeTable.getSelectedRows()) {
                if (!((NodeAbstract)this.treeTable.getPathForRow(i).getLastPathComponent()).isFolder()) continue;
                JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantDeleteMultipleFolders"), I18N.translate((String)"TitleCantDeleteMultipleFolders"), 2);
                return;
            }
            int[] selectedRows = this.treeTable.getSelectedRows();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                try {
                    ((NodeAbstract)this.treeTable.getPathForRow(selectedRows[i]).getLastPathComponent()).delete();
                }
                catch (FileOperationNotAllowedException ex) {
                    Logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (java.lang.Exception e) {
                    JOptionPane.showMessageDialog(this, e.toString(), I18N.translate((String)"TitleCantDeleteItem"), 0);
                    break;
                }
                this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(selectedRows[i]).getParentPath());
            }
        }
        this.enableOrDisableActions();
    }

    protected void replaceFileButtonClicked() {
        if (this.selectedNode == null) {
            return;
        }
        if (this.selectedNode.isFolder()) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser(this.launcherView.getDataDirectory());
        fileChooser.setDialogType(0);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleReplaceFile"));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        if (fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.launcherView.setDataDirectory(FileUtil.asCanonicalFileName((String)fileChooser.getSelectedFile().getParent()));
        if (this.launcherView.getDataDirectory().isEmpty()) {
            this.launcherView.setDataDirectory(FileUtil.asCanonicalFileName((String)PackerConstants.USER_HOME));
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ((NodeFile)this.selectedNode).replaceByFile(fileChooser.getSelectedFile().getCanonicalPath());
        }
        catch (FileOperationNotAllowedException ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (java.lang.Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), I18N.translate((String)"TitleCantReplaceFile"), 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        int rememberSelectedIndex = this.selectedIndex;
        this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(this.selectedIndex).getParentPath());
        this.treeTable.getSelectionModel().setSelectionInterval(rememberSelectedIndex, rememberSelectedIndex);
    }

    protected void migrateFileManuallyButtonClicked() {
        if (this.selectedNode == null || this.selectedNode.isFile()) {
            return;
        }
        if (!new AssignLevelsByLayerDialog((JFrame)this, (NodeAbstract)this.selectedNode).goButtonWasClicked) {
            return;
        }
        this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(this.selectedIndex));
        this.enableOrDisableActions();
    }

    protected void openSAExternallyButtonClicked() {
        try {
            this.document.getSubmissionAgreement().openAsHTMLExternally();
        }
        catch (java.lang.Exception e) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantOpenSAExternally", (Object[])new Object[]{e.toString()}), I18N.translate((String)"TitleCantOpenSAExternally"), 0);
        }
    }

    protected void testOrAssignSAButtonClicked() {
        TestOrAssignSADialog dialog = new TestOrAssignSADialog(this);
        if (!dialog.setSAButtonClicked) {
            return;
        }
        this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(0));
        this.enableOrDisableActions();
    }

    protected void openAssignLevelsByLayerViewButtonClicked() {
        if (this.selectedNode == null || this.selectedNode.isFile()) {
            return;
        }
        if (!new AssignLevelsByLayerDialog((JFrame)this, (NodeAbstract)this.selectedNode).goButtonWasClicked) {
            return;
        }
        this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(this.selectedIndex));
        this.enableOrDisableActions();
    }

    protected void openAssignLevelsByLabelViewButtonClicked() {
        if (this.selectedNode == null) {
            return;
        }
        if (this.selectedNode.isFile()) {
            return;
        }
        if (!new AssignLevelsByLabelDialog((JFrame)this, (NodeAbstract)this.selectedNode).goButtonWasClicked) {
            return;
        }
        this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(this.selectedIndex));
        this.enableOrDisableActions();
    }

    protected void setLevelButtonClicked(ActionEvent e) {
        ExceptionCollector.clear();
        LevelOfDescription level = this.document.getLevels().get(e.getActionCommand());
        if (this.treeTable.getSelectedRowCount() >= 2) {
            for (int i : this.treeTable.getSelectedRows()) {
                try {
                    ((NodeAbstract)this.treeTable.getPathForRow(i).getLastPathComponent()).setLevel(level);
                }
                catch (java.lang.Exception ex) {
                    Exception.remember((Throwable)ex);
                }
                this.getTreeTableModel().refreshNode(this.treeTable.getPathForRow(i));
            }
            return;
        }
        try {
            this.selectedNode.setLevel(level);
        }
        catch (java.lang.Exception ex) {
            Exception.remember((Throwable)ex);
        }
        this.getTreeTableModel().refreshNode(this.treeTable.getPathForRow(this.selectedIndex));
        this.fillInsertMetadataElementComboBox();
        this.updateView();
        int lastEventIndex = this.selectedNode.getMyEvents().size() - 1;
        this.eventTable.getSelectionModel().setSelectionInterval(lastEventIndex, lastEventIndex);
        if (!ExceptionCollector.isEmpty().booleanValue()) {
            ExceptionCollector.systemOut();
        }
    }

    protected void setSubmitRequestButtonClicked() {
        ExceptionCollector.clear();
        for (int i : this.treeTable.getSelectedRows()) {
            NodeAbstract nodeCurrent;
            NodeAbstract nodeParent = nodeCurrent = (NodeAbstract)this.treeTable.getPathForRow(i).getLastPathComponent();
            while (!(nodeParent.isRoot().booleanValue() || ((NodeAbstract)nodeParent.getParent()).getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.SubmitRequested) || ((NodeAbstract)nodeParent.getParent()).getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.Submitted))) {
                nodeParent = (NodeAbstract)nodeParent.getParent();
                try {
                    nodeParent.setSubmitStatus_check(NodeAbstract.SubmitStatus.SubmitRequested);
                }
                catch (CantSetSubmitStatusNotAllowedException ex) {
                    Exception.remember((Throwable)ex);
                }
            }
            try {
                nodeCurrent.setSubmitStatusRecursivelyAllOrNone_check(NodeAbstract.SubmitStatus.SubmitRequested);
            }
            catch (CantSetSubmitStatusRecursiveException ex) {
                Exception.remember((Throwable)ex);
            }
            if (!ExceptionCollector.isEmpty().booleanValue()) {
                ExceptionCollector.systemOut();
                continue;
            }
            nodeCurrent.setSubmitStatusRecursivelyAllOrNone_force(NodeAbstract.SubmitStatus.SubmitRequested);
            nodeParent = nodeCurrent;
            while (!(nodeParent.isRoot().booleanValue() || ((NodeAbstract)nodeParent.getParent()).getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.SubmitRequested) || ((NodeAbstract)nodeParent.getParent()).getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.Submitted))) {
                nodeParent = (NodeAbstract)nodeParent.getParent();
                nodeParent.setSubmitStatus_force(NodeAbstract.SubmitStatus.SubmitRequested);
            }
            this.getTreeTableModel().refreshNode(this.treeTable.getPathForRow(i));
        }
        this.updateView();
    }

    protected void setSubmitRetractButtonClicked() {
        ExceptionCollector.clear();
        for (int i : this.treeTable.getSelectedRows()) {
            try {
                ((NodeAbstract)this.treeTable.getPathForRow(i).getLastPathComponent()).setSubmitStatusRecursivelyAllOrNone_check(NodeAbstract.SubmitStatus.SubmitUndefined);
                ((NodeAbstract)this.treeTable.getPathForRow(i).getLastPathComponent()).setSubmitStatusRecursivelyAllOrNone_force(NodeAbstract.SubmitStatus.SubmitUndefined);
            }
            catch (java.lang.Exception ex) {
                Exception.remember((Throwable)ex);
            }
            this.getTreeTableModel().refreshNode(this.treeTable.getPathForRow(i));
        }
        this.updateView();
        if (!ExceptionCollector.isEmpty().booleanValue()) {
            ExceptionCollector.systemOut();
        }
    }

    protected void exportAsEADFileButtonClicked() {
        JFileChooser fileChooser = new JFileChooser(this.launcherView.getLastUsedOpenOrSaveDirectory());
        fileChooser.setDialogType(1);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleExportAsEADFile"));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        File suggestedFile = new File(this.launcherView.getLastUsedOpenOrSaveDirectory(), this.document.getSIPName() + ".xml");
        fileChooser.setSelectedFile(suggestedFile);
        if (fileChooser.showSaveDialog(this) != 0) {
            return;
        }
        try {
            this.document.createEADFile(fileChooser.getSelectedFile().getPath());
        }
        catch (java.lang.Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createExport(String exportName) {
        String eadFilePath = FileUtil.getTempFolder() + "/" + this.document.getSIPName() + ".xml";
        String exportStylesheet = this.launcherView.getExportsDirectory() + File.separator + exportName + ".xsl";
        FileDialog fileDialog = new FileDialog((Frame)this, I18N.translate((String)"TitleExportAsEADFile"), 1);
        fileDialog.setDirectory(new File(this.launcherView.getLastUsedOpenOrSaveDirectory()).getAbsolutePath());
        fileDialog.setFile(this.document.getSIPName() + "_" + exportName + ".xml");
        fileDialog.setLocationRelativeTo(this);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        String exportFilePath = fileDialog.getDirectory() + fileDialog.getFile();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.document.createEADFile(eadFilePath);
            XMLTransformer.transformXML(eadFilePath, exportStylesheet, exportFilePath);
        }
        catch (ExceptionCollectorException | IOException | DocumentException e) {
            Logger.error((Object)I18N.translate((String)"MessageCouldNotCreateOutput", (Object[])new Object[]{eadFilePath}), (Throwable)e);
        }
        catch (TransformerException e) {
            Logger.error((Object)I18N.translate((String)"MessageCouldNotCreateOutput", (Object[])new Object[]{exportFilePath}), (Throwable)e);
        }
        finally {
            try {
                FileUtil.delete((String)eadFilePath);
            }
            catch (FileUtilExceptionListException e) {
                Logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void exportAsCSVFileButtonClicked() {
        FileDialog fileDialog = new FileDialog((Frame)this, I18N.translate((String)"TitleExportAsCSVFile"), 1);
        fileDialog.setDirectory(new File(this.launcherView.getLastUsedOpenOrSaveDirectory()).getAbsolutePath());
        fileDialog.setFile(this.document.getSIPName() + ".csv");
        fileDialog.setLocationRelativeTo(this);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return;
        }
        try {
            CSVExport.export(this.document, fileDialog.getDirectory() + fileDialog.getFile());
        }
        catch (java.lang.Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void exportAsSEDA_ActionButtonClicked(final ExporterSEDA exporter, String dialogTitleKey, final String successfulMessageKey, final String failedMessageKey) {
        final JFileChooser fileChooser = new JFileChooser(this.launcherView.getLastUsedOpenOrSaveDirectory());
        fileChooser.setDialogType(1);
        fileChooser.setDialogTitle(I18N.translate((String)dialogTitleKey));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        if (fileChooser.showSaveDialog(this) != 0) {
            return;
        }
        SwingWorker<Boolean, Boolean> worker = new SwingWorker<Boolean, Boolean>(){
            boolean successfullyExported = false;
            Path sedaSIPPath = null;

            @Override
            protected Boolean doInBackground() throws java.lang.Exception {
                try {
                    SIPView.this.saveSIP(null, false);
                    this.sedaSIPPath = fileChooser.getSelectedFile().toPath();
                    FileProperty fileProperty = SIPView.this.getFileProperty();
                    this.successfullyExported = exporter.exportMetsToSEDA(fileProperty.getFile().toPath(), this.sedaSIPPath, "docuteam packer");
                    return this.successfullyExported;
                }
                catch (java.lang.Exception e) {
                    Logger.error((Object)("error at exportAsSEDA_ActionButtonClicked: " + e));
                    return false;
                }
            }

            @Override
            protected void done() {
                if (this.successfullyExported) {
                    JOptionPane.showMessageDialog(SIPView.this.splitPane, I18N.translate((String)successfulMessageKey) + " " + this.sedaSIPPath.toString());
                } else {
                    JOptionPane.showMessageDialog(SIPView.this.splitPane, I18N.translate((String)failedMessageKey));
                }
            }
        };
        worker.execute();
    }

    protected void exportButtonClicked() {
        if (this.selectedNode == null || this.treeTable.getSelectedRowCount() >= 2) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser(this.launcherView.getDataDirectory());
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleSelectExportDestinationFolder"));
        fileChooser.setMultiSelectionEnabled(false);
        int result = fileChooser.showSaveDialog(this);
        if (result == 1) {
            return;
        }
        String destinationFolder = fileChooser.getSelectedFile().getPath();
        if (new File(destinationFolder + "/" + this.selectedNode.getFile().getName()).exists() && JOptionPane.showConfirmDialog(this, I18N.translate((String)"QuestionExportOverwriteFile"), I18N.translate((String)"TitleExportItem"), 0) != 0) {
            return;
        }
        try {
            FileUtil.copyToFolderMerging((File)this.selectedNode.getFile(), (File)new File(destinationFolder));
        }
        catch (java.lang.Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAsTemplateButtonClicked() {
        Boolean ok;
        if (this.document == null) {
            return;
        }
        String title = I18N.translate((String)"TitleCreateTemplate");
        Object message = I18N.translate((String)"MessageEnterNewTemplateName");
        int messageType = 3;
        String textFieldContent = new File(this.document.getSIPFolder().trim()).getName();
        block11: do {
            String newItemName;
            if ((newItemName = (String)JOptionPane.showInputDialog(this, message, title, messageType, null, null, textFieldContent)) == null) {
                return;
            }
            if ((newItemName = newItemName.trim()).length() == 0) {
                return;
            }
            ok = true;
            if (!FileUtil.isFileNameAllowed((String)newItemName)) {
                ok = false;
                title = I18N.translate((String)"TitleCantCreateTemplate");
                message = I18N.translate((String)"MessageBadLettersInFilename") + "\n" + I18N.translate((String)"MessageEnterNewTemplateName");
                messageType = 2;
                textFieldContent = newItemName;
                continue;
            }
            if (new File(this.launcherView.getTemplateDirectory() + "/" + newItemName).exists()) {
                int confirm = JOptionPane.showConfirmDialog(this, I18N.translate((String)"MessageOverwriteExistingTemplate"));
                switch (confirm) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ok = false;
                        title = I18N.translate((String)"TitleCreateTemplate");
                        message = I18N.translate((String)"MessageEnterNewTemplateName");
                        messageType = 3;
                        textFieldContent = new File(this.document.getSIPFolder()).getName();
                        continue block11;
                    }
                    default: {
                        return;
                    }
                }
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.document.saveAsTemplate(this.launcherView.getTemplateDirectory() + "/" + newItemName);
                this.enableOrDisableActions();
                this.setFooterText(I18N.translate((String)"MessageFooterTemplateSaved") + newItemName);
            }
            catch (CantCreateTemplateWithRootFileException ex) {
                JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantCreateTemplateWithRootFile"));
                return;
            }
            catch (java.lang.Exception ex) {
                ok = false;
                title = I18N.translate((String)"TitleCantCreateTemplate");
                message = ex.getMessage() + "\n" + I18N.translate((String)"MessageEnterNewTemplateName");
                messageType = 2;
                textFieldContent = this.document.getName();
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        } while (!ok.booleanValue());
    }

    protected void openDocuteamHomepage() {
        if (!Desktop.isDesktopSupported()) {
            System.err.println("Desktop is not supported");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            System.err.println("Desktop doesn't support the browse action");
            return;
        }
        try {
            desktop.browse(new URI("http://www.docuteam.ch"));
        }
        catch (java.lang.Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void expandAll() {
        this.treeTable.expandAll();
    }

    protected void insertMetadataElement() {
        LevelMetadataElement lme = (LevelMetadataElement)this.selectMetadataElementComboBox.getSelectedItem();
        try {
            this.selectedNode.addDynamicMetadataElementInstanceWithName(lme.getId());
        }
        catch (MetadataElementCantAddException ex) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantAddMetadataElement"), lme.getId(), 0);
        }
        catch (java.lang.Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.fillInsertMetadataElementComboBox();
        this.updateView();
    }

    protected void removeMetadataElement() {
        MetadataElementInstance me = ((MetadataTableModel)this.metadataTable.getModel()).get(this.metadataTable.getSelectedRow());
        try {
            this.selectedNode.deleteDynamicMetadataElementInstanceWithName(me.getName(), me.getIndex());
        }
        catch (MetadataElementCantDeleteException ex) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageCantDeleteMetadataElement"), me.getName(), 0);
        }
        catch (java.lang.Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.fillInsertMetadataElementComboBox();
        this.updateView();
    }

    protected void metaTitleTextFieldWasChanged() {
        if (this.metaTitleTextField.getText().equals(this.selectedNode.getUnitTitle())) {
            return;
        }
        this.selectedNode.setUnitTitle(this.metaTitleTextField.getText());
        this.updateView();
    }

    protected void redisplayNode() {
        if (this.selectedIndex == -1) {
            return;
        }
        this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(this.selectedIndex).getParentPath());
        this.treeTable.expandRow(this.selectedIndex);
        this.treeTable.getSelectionModel().setSelectionInterval(this.selectedIndex, this.selectedIndex);
    }

    public void selectNode(String admId) {
        Logger.debug((Object)("Select admId: " + admId));
        NodeAbstract node = this.document.getStructureMap().getRoot().searchId(admId);
        if (node == null) {
            return;
        }
        this.selectNode(node);
    }

    protected void selectNode(NodeAbstract node) {
        Logger.debug((Object)("Select Node: " + node));
        if (node == null) {
            return;
        }
        this.selectNode(node.getTreePath());
    }

    private void selectNode(TreePath treePath) {
        Logger.debug((Object)("Select Path: " + treePath));
        if (treePath == null) {
            return;
        }
        this.treeTable.getTreeSelectionModel().setSelectionPath(treePath);
        this.treeTable.scrollPathToVisible(treePath);
    }

    private void checkSubmission() {
        List<String> submitCheckMessages = AIPCreatorProxy.getAIPCreator().checkSubmission(this.document);
        if (submitCheckMessages.isEmpty()) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageSubmitCheckSuccessful"), I18N.translate((String)"HeaderSubmitCheck"), 1);
        } else {
            new ScrollableMessageDialog((Window)this, I18N.translate((String)"HeaderSubmitCheck"), this.translateAndFormat(I18N.translate((String)"MessageSubmitCheckFailed"), submitCheckMessages));
        }
    }

    protected void submit() {
        if (this.document.isModified()) {
            int answer = JOptionPane.showConfirmDialog(this, "'" + this.document.getSIPName() + "':\n" + I18N.translate((String)"QuestionSaveModified"), I18N.translate((String)"TitleCloseSIP"), 1, 3);
            switch (answer) {
                case 0: {
                    this.saveCopyAs(null, false);
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (JOptionPane.showConfirmDialog(this, I18N.translate((String)"MessageSubmitAsk"), I18N.translate((String)"HeaderSubmit"), 2, 3) != 0) {
            return;
        }
        Logger.debug((Object)("Submitting SIP: '" + this.document.getSIPName() + "'"));
        new SwingWorker<Integer, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInBackground() {
                List<Object> submitCheckMessages = new ArrayList<CallSite>();
                try (SmallPeskyMessageWindow w = SmallPeskyMessageWindow.openBlocking((Window)SIPView.this, (String)I18N.translate((String)"MessageTempSubmitting"));){
                    submitCheckMessages = AIPCreatorProxy.getAIPCreator().submit(SIPView.this.document);
                }
                if (submitCheckMessages.isEmpty()) {
                    JOptionPane.showMessageDialog(SIPView.this, I18N.translate((String)"MessageSubmitDone"));
                    Path originalSipPath = Paths.get(SIPView.this.document.getOriginalSIPFolder(), new String[0]);
                    if (!Files.exists(originalSipPath, new LinkOption[0])) {
                        SIPView.this.launcherView.unregister(SIPView.this);
                        SIPView.this.setVisible(false);
                        SIPView.this.dispose();
                        SIPView.this.launcherView.getSipTable().getSipTableModel().removeSipFromView(SIPView.this.fileProperty);
                    } else {
                        SIPView.this.launcherView.refreshSIPTable();
                    }
                } else {
                    new ScrollableMessageDialog((Window)SIPView.this, I18N.translate((String)"HeaderSubmit"), SIPView.this.translateAndFormat(I18N.translate((String)"MessageSubmitCheckFailed"), submitCheckMessages));
                }
                return 0;
            }
        }.execute();
    }

    /*
     * Exception decompiling
     */
    protected void createReport(String reportName, String stylesheetName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getReportFilePath(String reportName, String extension) {
        Object reportFilePath = "";
        FileDialog fileDialog = new FileDialog((Frame)this, I18N.translate((String)"LabelSaveReportAs"), 1);
        fileDialog.setDirectory(this.getReportDestinationDirPath());
        fileDialog.setFile(this.document.getSIPName() + "_" + reportName + extension);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            reportFilePath = fileDialog.getDirectory() + fileDialog.getFile();
        }
        return reportFilePath;
    }

    private String getReportDestinationDirPath() {
        return this.launcherView.getReportsDestinationDirectory();
    }

    protected String translateAndFormat(CantSetSubmitStatusRecursiveException ex) {
        return this.translateAndFormat(I18N.translate((String)"MessageSettingSubmitStatusFailed", (Object[])new Object[]{I18N.translate((String)ex.getSubmitStatus().name())}), ex.getRejectMessages());
    }

    protected String translateAndFormat(String firstRow, List<String> messageList) {
        StringBuilder messageString = new StringBuilder(firstRow);
        for (String s : messageList) {
            String message;
            int separatorIndex = s.indexOf(" ");
            if (separatorIndex > 0) {
                message = I18N.translate((String)s.substring(0, separatorIndex));
                String additionalInfos = s.substring(separatorIndex);
                if (additionalInfos.contains("I18N{") && additionalInfos.contains("}")) {
                    int keywordEndIndex;
                    int keywordStartIndex;
                    int startIndex = 0;
                    while ((keywordStartIndex = additionalInfos.indexOf("I18N{", startIndex)) != -1 && (keywordEndIndex = additionalInfos.indexOf("}", keywordStartIndex)) != -1) {
                        String keyword = additionalInfos.substring(keywordStartIndex + "I18N{".length(), keywordEndIndex);
                        String keywordTranslated = I18N.translate((String)keyword);
                        additionalInfos = additionalInfos.replace(additionalInfos.substring(keywordStartIndex, keywordEndIndex + "}".length()), keywordTranslated);
                        startIndex = keywordStartIndex + keywordTranslated.length();
                    }
                }
                messageString.append(additionalInfos).append(": ");
            } else {
                message = I18N.translate((String)s);
            }
            messageString.append(message).append("\n");
        }
        return messageString.toString();
    }

    protected void setDividerLocation(int width) {
        this.splitPane.setDividerLocation(width);
    }

    public void enableOrDisableActions() {
        this.saveAction.setEnabled(false);
        this.saveAsAction.setEnabled(false);
        this.normalizeAction.setEnabled(false);
        this.checkFixityAction.setEnabled(false);
        this.closeAction.setEnabled(false);
        this.openSAExternallyAction.setEnabled(false);
        this.testOrAssignSAAction.setEnabled(false);
        this.exportAsEADFileAction.setEnabled(false);
        this.exportAction.setEnabled(false);
        this.expandAllAction.setEnabled(false);
        this.collapseAllAction.setEnabled(false);
        this.saveAsTemplateAction.setEnabled(false);
        this.submitCheckAction.setEnabled(false);
        this.submitAction.setEnabled(false);
        this.exportAsEADFileAction.setEnabled(false);
        this.exportAsCSVFileAction.setEnabled(false);
        this.removeTrashAction.setEnabled(false);
        this.removeDuplicatesAction.setEnabled(false);
        this.deleteItemAction.setEnabled(false);
        this.deleteItemDontAskAction.setEnabled(false);
        this.renameItemAction.setEnabled(false);
        this.sortAction.setEnabled(false);
        this.replaceFileAction.setEnabled(false);
        this.appendMigratedFileAction.setEnabled(false);
        this.createFolderAction.setEnabled(false);
        this.insertAction.setEnabled(false);
        this.openAssignLevelsByLayerViewAction.setEnabled(false);
        this.openAssignLevelsByLabelViewAction.setEnabled(false);
        this.redisplayNodeAction.setEnabled(false);
        this.exportAction.setEnabled(false);
        this.convertAction.setEnabled(false);
        this.submitRequestAction.setEnabled(false);
        this.submitRetractAction.setEnabled(false);
        this.itemLevelsSubMenu.setEnabled(false);
        for (Action setLevelAction : this.setLevelActions) {
            setLevelAction.setEnabled(false);
        }
        this.metaTitleTextField.setEnabled(false);
        this.selectMetadataElementComboBox.setEnabled(false);
        this.insertMetadataElementAction.setEnabled(false);
        this.removeMetadataElementAction.setEnabled(false);
        if (this.document == null) {
            Logger.warn((Object)"Document is null???");
            this.showInInfoLabel("");
            return;
        }
        this.saveAsAction.setEnabled(!this.document.isAtLeastOneFileNotReadable());
        this.checkFixityAction.enableOrDisable();
        this.convertAction.enableOrDisable();
        this.closeAction.setEnabled(true);
        if (properties.getProperty("docuteamPacker.SA.BASE.URL") != null) {
            this.openSAExternallyAction.setEnabled(true);
        }
        this.importMetadataFromCSVMenuAction.enableOrDisable();
        this.importMetadataFromCSVContextAction.enableOrDisable();
        this.exportAsEADFileAction.setEnabled(true);
        this.expandAllAction.setEnabled(true);
        this.collapseAllAction.setEnabled(true);
        this.saveAsTemplateAction.setEnabled(true);
        this.exportAsEADFileAction.setEnabled(true);
        this.exportAsCSVFileAction.setEnabled(true);
        boolean documentIsWritable = this.document.canWrite();
        if (!documentIsWritable) {
            if (this.document.isLocked()) {
                this.showInInfoLabel(I18N.translate((String)"LabelIsLocked") + this.document.getLockedBy(), true);
            } else if (this.document.isReadOnly()) {
                this.showInInfoLabel(I18N.translate((String)"LabelIsReadOnly"), true);
            } else {
                this.showInInfoLabel("");
            }
        } else {
            this.saveAction.setEnabled(true);
            this.testOrAssignSAAction.setEnabled(true);
            this.removeTrashAction.setEnabled(true);
            this.removeDuplicatesAction.setEnabled(true);
            if (AIPCreatorProxy.isUsable()) {
                this.submitCheckAction.setEnabled(true);
                this.submitAction.setEnabled(true);
            }
            if (this.document.isModified()) {
                this.showInInfoLabel(I18N.translate((String)"LabelIsModified"));
            } else if (this.document.hasNodesWithDynamicMetadataElementInstancesWhichAreMandatoryButNotSet()) {
                this.showInInfoLabel(I18N.translate((String)"MessageMandatoryFieldsNotSet"), true);
            } else if (this.document.isReadWriteNoFileOps()) {
                this.showInInfoLabel(I18N.translate((String)"LabelIsReadWriteNoFileOps"), true);
            } else {
                this.showInInfoLabel("");
            }
        }
        if (this.treeTable.getSelectedRowCount() == 0) {
            return;
        }
        this.deleteFileContentAction.enableOrDisable();
        this.appendMigratedFileAction.enableOrDisable();
        this.exploreAction.enableOrDisable();
        if (this.treeTable.getSelectedRowCount() >= 2) {
            if (!documentIsWritable) {
                return;
            }
            boolean canDelete = this.document.isReadWrite();
            boolean hasUnsubmitted = false;
            boolean hasSubmissionRequests = false;
            HashMap<Action, Boolean> enabledLevelActions = new HashMap<Action, Boolean>();
            for (int i : this.treeTable.getSelectedRows()) {
                NodeAbstract selectedNode = (NodeAbstract)this.treeTable.getPathForRow(i).getLastPathComponent();
                canDelete = canDelete && selectedNode.isRoot() == false && selectedNode.fileExists() && selectedNode.canRead() && selectedNode.canWrite() && !selectedNode.hasPredecessorNotWritableByCurrentUser() && (!selectedNode.isFolder() || selectedNode.isFolder() && !((NodeFolder)selectedNode).hasDescendantNotWritableByCurrentUser()) && selectedNode.doesSubmitStatusAllowEditing();
                hasUnsubmitted = hasUnsubmitted || selectedNode.getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.SubmitUndefined) || selectedNode.getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.SubmitFailed);
                hasSubmissionRequests = hasSubmissionRequests || selectedNode.getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.SubmitRequested);
                boolean submitted = selectedNode.getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.Submitted);
                for (Action setLevelAction : this.setLevelActions) {
                    boolean currentLevelActionAllowed = selectedNode.doesParentAllowSubLevel((String)setLevelAction.getValue("Name")) && !submitted;
                    Boolean levelActionAccumulated = enabledLevelActions.get(setLevelAction) == null ? true : (Boolean)enabledLevelActions.get(setLevelAction);
                    Boolean levelActionAllowed = levelActionAccumulated != false && currentLevelActionAllowed;
                    enabledLevelActions.put(setLevelAction, levelActionAllowed);
                }
            }
            this.deleteItemAction.setEnabled(canDelete);
            this.deleteItemDontAskAction.setEnabled(canDelete);
            this.submitRequestAction.setEnabled(hasUnsubmitted);
            this.submitRetractAction.setEnabled(hasSubmissionRequests);
            this.itemLevelsSubMenu.setEnabled(true);
            Object object = this.setLevelActions.iterator();
            while (object.hasNext()) {
                Action setLevelAction = (Action)object.next();
                setLevelAction.setEnabled((Boolean)enabledLevelActions.get(setLevelAction));
            }
            this.normalizeAction.setEnabled(this.canNormalize());
            return;
        }
        TreePath pathForSelectedRow = this.treeTable.getPathForRow(this.selectedIndex);
        if (pathForSelectedRow == null) {
            return;
        }
        if (this.selectedNode == null) {
            return;
        }
        if (!documentIsWritable) {
            this.redisplayNodeAction.setEnabled(this.selectedNode.isFolder());
            this.exportAction.setEnabled(true);
            return;
        }
        if (this.selectedNode.isFolder()) {
            this.redisplayNodeAction.setEnabled(true);
            if (this.selectedNode.fileExists() && this.selectedNode.canRead()) {
                if (!this.selectedNode.canWrite()) {
                    this.exportAction.setEnabled(true);
                } else if (this.selectedNode.hasPredecessorNotWritableByCurrentUser()) {
                    this.openAssignLevelsByLayerViewAction.setEnabled(true);
                    this.openAssignLevelsByLabelViewAction.setEnabled(true);
                    this.exportAction.setEnabled(true);
                    this.enableDynamicMetadataActions();
                    this.enableOnlyAllowedSetLevelActions();
                } else if (((NodeFolder)this.selectedNode).hasDescendantNotWritableByCurrentUser()) {
                    boolean structureEnabled = this.document.isReadWrite();
                    boolean metadataEnabled = this.document.getMode().equals((Object)Document.Mode.ReadWrite) || this.document.getMode().equals((Object)Document.Mode.ReadWriteNoFileOps);
                    this.renameItemAction.setEnabled(structureEnabled);
                    this.sortAction.setEnabled(structureEnabled);
                    this.createFolderAction.setEnabled(structureEnabled);
                    this.insertAction.setEnabled(structureEnabled);
                    this.openAssignLevelsByLayerViewAction.setEnabled(metadataEnabled);
                    this.openAssignLevelsByLabelViewAction.setEnabled(metadataEnabled);
                    this.exportAction.setEnabled(true);
                    this.enableDynamicMetadataActions();
                    this.enableOnlyAllowedSetLevelActions();
                } else if (!this.selectedNode.doesSubmitStatusAllowEditing()) {
                    this.createFolderAction.setEnabled(true);
                    this.insertAction.setEnabled(true);
                    this.exportAction.setEnabled(true);
                    if (this.selectedNode.getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.SubmitRequested)) {
                        this.submitRetractAction.setEnabled(true);
                    }
                } else {
                    boolean metadataEnabled;
                    boolean structureEnabled = this.document.isReadWrite();
                    boolean bl = metadataEnabled = this.document.getMode().equals((Object)Document.Mode.ReadWrite) || this.document.getMode().equals((Object)Document.Mode.ReadWriteNoFileOps);
                    if (!this.selectedNode.isRoot().booleanValue()) {
                        this.deleteItemAction.setEnabled(structureEnabled);
                        this.deleteItemDontAskAction.setEnabled(structureEnabled);
                    }
                    this.submitRequestAction.setEnabled(true);
                    this.renameItemAction.setEnabled(structureEnabled);
                    this.sortAction.setEnabled(structureEnabled);
                    this.createFolderAction.setEnabled(structureEnabled);
                    this.insertAction.setEnabled(structureEnabled);
                    this.openAssignLevelsByLayerViewAction.setEnabled(metadataEnabled);
                    this.openAssignLevelsByLabelViewAction.setEnabled(metadataEnabled);
                    this.exportAction.setEnabled(true);
                    this.normalizeAction.setEnabled(structureEnabled);
                    this.enableDynamicMetadataActions();
                    this.enableOnlyAllowedSetLevelActions();
                }
            }
        } else if (this.selectedNode.fileExists() && this.selectedNode.canRead()) {
            if (!this.selectedNode.canWrite()) {
                this.exportAction.setEnabled(true);
            } else if (this.selectedNode.hasPredecessorNotWritableByCurrentUser()) {
                this.exportAction.setEnabled(true);
                this.enableDynamicMetadataActions();
                this.enableOnlyAllowedSetLevelActions();
            } else if (!this.selectedNode.doesSubmitStatusAllowEditing()) {
                this.exportAction.setEnabled(true);
                if (this.selectedNode.getSubmitStatus().equals((Object)NodeAbstract.SubmitStatus.SubmitRequested)) {
                    this.submitRetractAction.setEnabled(true);
                }
            } else {
                boolean enabled = this.document.isReadWrite();
                if (!this.selectedNode.isRoot().booleanValue()) {
                    this.deleteItemAction.setEnabled(enabled);
                    this.deleteItemDontAskAction.setEnabled(enabled);
                }
                this.submitRequestAction.setEnabled(true);
                this.renameItemAction.setEnabled(enabled);
                this.sortAction.setEnabled(false);
                this.normalizeAction.setEnabled(enabled);
                this.exportAction.setEnabled(enabled);
                this.replaceFileAction.setEnabled(enabled);
                this.enableDynamicMetadataActions();
                this.enableOnlyAllowedSetLevelActions();
            }
        }
    }

    private boolean canNormalize() {
        boolean canNormalize = this.document.isReadWrite();
        for (int i : this.treeTable.getSelectedRows()) {
            NodeAbstract selectedNode = (NodeAbstract)this.treeTable.getPathForRow(i).getLastPathComponent();
            canNormalize = canNormalize && selectedNode.isRoot() == false && selectedNode.fileExists() && selectedNode.canRead() && selectedNode.canWrite() && !selectedNode.hasPredecessorNotWritableByCurrentUser() && (!selectedNode.isFolder() || selectedNode.isFolder() && !((NodeFolder)selectedNode).hasDescendantNotWritableByCurrentUser()) && selectedNode.doesSubmitStatusAllowEditing();
        }
        return canNormalize;
    }

    protected void enableOnlyAllowedSetLevelActions() {
        this.itemLevelsSubMenu.setEnabled(true);
        for (Action setLevelAction : this.setLevelActions) {
            setLevelAction.setEnabled(this.selectedNode.doesParentAllowSubLevel((String)setLevelAction.getValue("Name")));
        }
    }

    protected void enableDynamicMetadataActions() {
        this.metaTitleTextField.setEnabled(true);
        this.selectMetadataElementComboBox.setEnabled(true);
        this.insertMetadataElementAction.setEnabled(this.selectMetadataElementComboBox.getSelectedItem() != null);
        int selectedMetadataElementIndex = this.metadataTable.getSelectedRow();
        if (selectedMetadataElementIndex == -1) {
            this.removeMetadataElementAction.setEnabled(false);
        } else {
            try {
                this.removeMetadataElementAction.setEnabled(((MetadataTableModel)this.metadataTable.getModel()).get(selectedMetadataElementIndex).canBeDeleted());
            }
            catch (java.lang.Exception ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected void updateView() {
        ((FileDataViewTableModel)this.dataTable.getModel()).setFileStructureNode(this.selectedNode);
        ((EventListTableModel)this.eventTable.getModel()).setFileStructureNode(this.selectedNode);
        ((MetadataTableModel)this.metadataTable.getModel()).setFileStructureNode(this.selectedNode);
        if (this.selectedNode == null) {
            this.metaTitleTextField.setText(null);
            this.metaLevelTextField.setText(null);
        } else {
            this.metaTitleTextField.setText(this.selectedNode.getUnitTitle());
            this.metaTitleTextField.setCaretPosition(0);
            this.metaLevelTextField.setText(this.selectedNode.getLevel().getName());
        }
        this.enableOrDisableActions();
    }

    protected void clearView() {
        ((FileDataViewTableModel)this.dataTable.getModel()).setFileStructureNode(null);
        ((EventListTableModel)this.eventTable.getModel()).setFileStructureNode(null);
        ((MetadataTableModel)this.metadataTable.getModel()).setFileStructureNode(null);
        this.metaTitleTextField.setText(null);
        this.metaLevelTextField.setText(null);
        this.enableOrDisableActions();
    }

    protected static Comparator<LevelMetadataElement> getLevelMetadataElementComparator() {
        String metadataOrder = properties.getProperty("docuteamPacker.SIPView.metadataOrder", "none");
        if (metadataOrder.equals("alphabetical")) {
            return (lme1, lme2) -> I18N.translate((String)lme1.getId()).compareTo(I18N.translate((String)lme2.getId()));
        }
        return (lme1, lme2) -> 0;
    }

    protected void fillInsertMetadataElementComboBox() {
        this.selectMetadataElementComboBox.removeAllItems();
        this.selectMetadataElementComboBox.addItem(null);
        List<LevelMetadataElement> sortedLevelMetadataElementsList = this.selectedNode.getDynamicMetadataElementsWhichCanBeAdded();
        Collections.sort(sortedLevelMetadataElementsList, SIPView.getLevelMetadataElementComparator());
        for (LevelMetadataElement lme : sortedLevelMetadataElementsList) {
            this.selectMetadataElementComboBox.addItem(lme);
        }
    }

    protected void showInInfoLabel(String message) {
        this.showInInfoLabel(message, false);
    }

    protected void showInInfoLabel(String message, boolean emphasized) {
        this.infoLabel.setForeground(emphasized ? Color.RED : Color.BLACK);
        this.infoLabel.setText(message);
    }

    protected void systemOutDocument() {
        Logger.info((Object)((Object)this.document));
    }

    private void sortButtonClicked() {
        if (this.selectedNode != null && this.selectedIndex != -1 && this.selectedNode instanceof NodeFolder) {
            ((NodeFolder)this.selectedNode).setOrderRecursive(-1, true);
            this.getTreeTableModel().refreshTreeStructure(this.treeTable.getPathForRow(this.selectedIndex));
        }
    }

    private void removeTrash() {
        try {
            this.saveSIP(null, false);
            Optional<LevelOfDescription> optionalTrashLevel = this.document.getLevels().getTrashLevel();
            if (!optionalTrashLevel.isPresent()) {
                JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageTitleNoTrashLevelDefined"), I18N.translate((String)"MessageNoTrashLevelDefined"), 2);
            } else {
                this.document = this.document.removeAllWithLevel(optionalTrashLevel.get());
                this.populateView(this.getDocument());
            }
        }
        catch (NodeWithLevelNotRemovableException e) {
            JOptionPane.showMessageDialog(this, I18N.translate((String)"MessageTitleRemoveTrashNotPossible"), I18N.translate((String)"MessageRemoveTrashNotPossible"), 2);
        }
        catch (java.lang.Exception e) {
            Logger.error((Object)"removeTrash failed: ", (Throwable)e);
        }
    }

    private void removeDuplicates() {
        try {
            this.saveSIP(null, false);
            new DuplicatesTableDialog(this.document.getStructureMap().getRoot(), this);
        }
        catch (DocumentIsReadOnlyException | FileOrFolderIsInUseException | OriginalSIPIsMissingException | FileUtilExceptionListException | IOException e) {
            Logger.error((Object)"removeDuplicates failed: ", (Throwable)e);
        }
    }

    public void updateTree() {
        TreePath rootPath = this.treeTable.getPathForRow(-1);
        this.getTreeTableModel().refreshTreeStructure(rootPath);
        this.updateView();
    }
}

