/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.tableModel;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.CSVMetadataValue;
import ch.docuteam.darc.mdconfig.LevelMetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementInstance;
import ch.docuteam.darc.mdconfig.RDFMetadataValue;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.util.KeyAndValue;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.packer.gui.sipView.StyledComboBoxUI;
import ch.docuteam.packer.gui.sipView.TextAreaTableCellEditor;
import ch.docuteam.packer.gui.sipView.cellRenderer.UnfocusableCellRenderer;
import ch.docuteam.tools.gui.TableModelWithSpecificCellEditorPerRow;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

public class MetadataTableModel
extends AbstractTableModel
implements TableModelWithSpecificCellEditorPerRow {
    private static final long serialVersionUID = 1L;
    private final SIPView sipView;
    private final UnfocusableCellRenderer unfocusableCellRenderer = new UnfocusableCellRenderer();
    private final TextAreaTableCellEditor textAreaRenderer = new TextAreaTableCellEditor();
    private final TextAreaTableCellEditor textAreaEditor = new TextAreaTableCellEditor();
    private final DefaultCellEditor comboBoxEditor = new DefaultCellEditor(new StyledComboBox());
    private TableCellEditor autocompleteEditor;
    private NodeAbstract fileStructureNode;
    private List<MetadataElementInstance> metadataElementInstances;

    public MetadataTableModel(SIPView sipView) {
        this.comboBoxEditor.setClickCountToStart(2);
        this.sipView = sipView;
    }

    public String getToolTipText(int i) {
        return this.metadataElementInstances.get(i).getToolTipText();
    }

    public MetadataElementInstance get(int i) {
        return this.metadataElementInstances.get(i);
    }

    public void setFileStructureNode(NodeAbstract fileStructureNode) {
        if (fileStructureNode == null) {
            fileStructureNode = null;
            this.metadataElementInstances = null;
        } else {
            this.fileStructureNode = fileStructureNode;
            this.metadataElementInstances = fileStructureNode.getDynamicMetadataElementInstancesToBeDisplayed();
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.metadataElementInstances == null) {
            return 0;
        }
        return this.metadataElementInstances.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return I18N.translate((String)"HeaderMetadataAttributes");
            }
            case 1: {
                return I18N.translate((String)"HeaderMetadataName");
            }
            case 2: {
                return I18N.translate((String)"HeaderMetadataValue");
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.metadataElementInstances == null) {
            return null;
        }
        MetadataElementInstance mdei = this.metadataElementInstances.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return mdei.getAttributesString();
            }
            case 1: {
                return I18N.translate((String)mdei.getName());
            }
            case 2: {
                return mdei.getDisplayValue();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 2) {
            return false;
        }
        if (!this.sipView.getDocument().canWrite()) {
            return false;
        }
        if (!(this.fileStructureNode.fileExists() && this.fileStructureNode.canRead() && this.fileStructureNode.canWrite())) {
            return false;
        }
        if (!this.fileStructureNode.doesSubmitStatusAllowEditing()) {
            return false;
        }
        if (this.metadataElementInstances == null) {
            return false;
        }
        return !this.metadataElementInstances.get(rowIndex).isReadOnly();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.metadataElementInstances == null) {
            return;
        }
        if (columnIndex != 2) {
            return;
        }
        try {
            if (value == null || value.toString().trim().isEmpty()) {
                this.metadataElementInstances.get(rowIndex).deleteMetadataElementInstanceFromNode();
                this.fireTableDataChanged();
                return;
            }
            if (value.getClass() == KeyAndValue.class) {
                this.metadataElementInstances.get(rowIndex).setValue(((KeyAndValue)value).getOriginalString());
            } else if (value instanceof RDFMetadataValue) {
                this.metadataElementInstances.get(rowIndex).setValue((RDFMetadataValue)value);
            } else if (value instanceof CSVMetadataValue) {
                this.metadataElementInstances.get(rowIndex).setValue((CSVMetadataValue)value);
            } else {
                this.metadataElementInstances.get(rowIndex).setValue(value.toString());
            }
        }
        catch (MetadataElementValidatorException ex) {
            JOptionPane.showMessageDialog(this.sipView, ex.getMessage());
        }
        catch (Exception ex) {
            Logger.warn((Object)"setValueAt failed: ", (Throwable)ex);
        }
        this.fireTableDataChanged();
    }

    public TableCellEditor getCellEditor(int rowIndex, int columnIndex) {
        if (this.metadataElementInstances == null) {
            return null;
        }
        LevelMetadataElement lme = this.metadataElementInstances.get(rowIndex).getLevelMetadataElement();
        List<KeyAndValue> allowedValues = lme.getMetadataElement().getAllowedValues();
        if (allowedValues != null && !allowedValues.isEmpty()) {
            JComboBox comboBox = (JComboBox)this.comboBoxEditor.getComponent();
            comboBox.removeAllItems();
            for (KeyAndValue item : allowedValues) {
                comboBox.addItem(item);
            }
            if (allowedValues.get(0).getOriginalString().equals("*")) {
                comboBox.removeItemAt(0);
                comboBox.setEditable(true);
            } else {
                comboBox.setEditable(false);
            }
            return this.comboBoxEditor;
        }
        this.autocompleteEditor = this.getAutocompleteEditor(lme);
        if (this.autocompleteEditor != null) {
            return this.autocompleteEditor;
        }
        int displayRows = lme.getDisplayRows();
        if (displayRows >= 2) {
            return this.textAreaEditor;
        }
        return null;
    }

    private TableCellEditor getAutocompleteEditor(LevelMetadataElement lme) {
        if (lme.getMetadataElement().getValueType().equals((Object)MetadataElement.VALUE_TYPE.skosFile)) {
            List<RDFMetadataValue> allowedValues = lme.getMetadataElement().getRdfAllowedValues();
            return this.getAutocompleteEditor(lme, allowedValues);
        }
        if (lme.getMetadataElement().getValueType().equals((Object)MetadataElement.VALUE_TYPE.csvFile)) {
            List<CSVMetadataValue> allowedValues = lme.getMetadataElement().getCsvAllowedValues();
            return this.getAutocompleteEditor(lme, allowedValues);
        }
        return null;
    }

    private <T> TableCellEditor getAutocompleteEditor(LevelMetadataElement lme, List<T> allowedValues) {
        if (allowedValues == null) {
            Logger.error((Object)"getAutocompleteEditor - allowedValues is null");
        } else if (allowedValues.isEmpty()) {
            Logger.warn((Object)("getAutocompleteEditor - allowedValues is empty: " + lme.getMetadataElement().getAccessorName()));
        } else {
            JComboBox<T> comboBox = this.createMetadataValueComboBox(allowedValues);
            AutoCompleteDecorator.decorate(comboBox);
            ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor(comboBox);
            return comboBoxCellEditor;
        }
        return null;
    }

    private <T> JComboBox<T> createMetadataValueComboBox(List<T> allowedValues) {
        JComboBox<T> comboBox = new JComboBox<T>();
        comboBox.addItem(null);
        for (T item : allowedValues) {
            comboBox.addItem(item);
        }
        comboBox.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                MetadataTableModel.this.cancelCellEditing();
            }
        });
        return comboBox;
    }

    private void cancelCellEditing() {
        this.autocompleteEditor.cancelCellEditing();
    }

    public TableCellRenderer getCellRenderer(int rowIndex, int columnIndex) {
        if (this.metadataElementInstances == null) {
            return null;
        }
        int displayRows = this.metadataElementInstances.get(rowIndex).getLevelMetadataElement().getDisplayRows();
        if (displayRows < 2) {
            return this.unfocusableCellRenderer;
        }
        return this.textAreaRenderer;
    }

    class StyledComboBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        public StyledComboBox() {
            this.setUI(new StyledComboBoxUI());
        }
    }
}

