/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;

public class FileSpecification {
    String _specString;
    PdfObject _sourceObject;

    public FileSpecification(PdfObject obj) throws PdfException {
        try {
            this._sourceObject = obj;
            if (obj instanceof PdfDictionary) {
                PdfDictionary dictObj = (PdfDictionary)obj;
                PdfSimpleObject pathObj = (PdfSimpleObject)dictObj.get("F");
                if (pathObj == null) {
                    pathObj = (PdfSimpleObject)dictObj.get("Unix");
                }
                if (pathObj == null) {
                    pathObj = (PdfSimpleObject)dictObj.get("DOS");
                }
                if (pathObj == null) {
                    pathObj = (PdfSimpleObject)dictObj.get("Mac");
                }
                if (pathObj != null) {
                    this._specString = pathObj.getStringValue();
                }
            } else if (obj instanceof PdfSimpleObject) {
                this._specString = ((PdfSimpleObject)obj).getStringValue();
            }
        }
        catch (ClassCastException e) {
            throw new PdfInvalidException("Invalid file specification");
        }
    }

    public String getSpecString() {
        return this._specString;
    }

    public PdfObject getSourceObject() {
        return this._sourceObject;
    }
}

