/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.Vector;

public class PdfArray
extends PdfObject {
    private Vector<PdfObject> _content = new Vector();

    public PdfArray(int objNumber, int genNumber) {
        super(objNumber, genNumber);
    }

    public PdfArray() {
    }

    public void add(PdfObject obj) {
        this._content.add(obj);
    }

    public Vector<PdfObject> getContent() {
        return this._content;
    }

    public boolean isPdfACompliant() {
        return this._content.size() <= 8191;
    }

    public String toPipeline() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._content.size(); ++i) {
            PdfObject elem = this._content.elementAt(i);
            if (!(elem instanceof PdfSimpleObject)) continue;
            String elemval = ((PdfSimpleObject)elem).getStringValue();
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(elemval);
        }
        return sb.toString();
    }

    public double[] toRectangle() {
        if (this._content.size() != 4) {
            return null;
        }
        double[] retval = new double[4];
        try {
            for (int i = 0; i < 4; ++i) {
                double d;
                PdfObject elem = this._content.elementAt(i);
                if (!(elem instanceof PdfSimpleObject)) {
                    return null;
                }
                retval[i] = d = ((PdfSimpleObject)elem).getDoubleValue();
            }
            return retval;
        }
        catch (Exception e) {
            return null;
        }
    }
}

