/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.Tokenizer;
import java.io.IOException;
import java.io.RandomAccessFile;

public class StreamTokenizer
extends Tokenizer {
    private Stream _stream;
    private boolean _backupFlag;
    private int _lastChar;

    public StreamTokenizer(RandomAccessFile file, Stream stream) {
        this._file = file;
        this._stream = stream;
        this._backupFlag = false;
    }

    @Override
    protected void initStream(Stream token) throws IOException, PdfException {
        throw new PdfMalformedException("Streams may not be embedded in object streams");
    }

    @Override
    public int readChar() throws IOException {
        if (this._backupFlag) {
            this._backupFlag = false;
            return this._lastChar;
        }
        this._lastChar = this._stream.read();
        return this._lastChar;
    }

    @Override
    public void seek(long offset) throws IOException, PdfException {
        if (!this._stream.advanceTo((int)offset)) {
            this._stream.initRead(this._file);
            this._stream.advanceTo((int)offset);
        }
        this.seekReset(this._stream.getOffset());
    }

    @Override
    protected void setStreamOffset(Stream token) throws IOException, PdfException {
        throw new PdfMalformedException("Streams may not be embedded in object streams");
    }

    @Override
    public void backupChar() {
        this._backupFlag = true;
    }
}

