/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.X1Profile;
import edu.harvard.hul.ois.jhove.module.pdf.XProfileBase;
import java.util.logging.Logger;

public final class X1aProfile
extends XProfileBase {
    private Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove.module");
    private X1Profile _x1Profile;

    public X1aProfile(PdfModule module) {
        super(module, XProfileBase.PDFX1A);
        this._profileText = "ISO PDF/X-1a";
    }

    public void setX1Profile(X1Profile x1) {
        this._x1Profile = x1;
    }

    @Override
    public boolean satisfiesThisProfile() {
        this._logger.info("Checking X1A profile");
        if (this._x1Profile != null) {
            if (!this._x1Profile.isAlreadyOK()) {
                return false;
            }
        } else {
            this._x1Profile = new X1Profile(this._module);
            if (!this._x1Profile.satisfiesProfile(this._raf, this._parser)) {
                return false;
            }
        }
        return this._x1Profile.isX1aCompliant();
    }
}

