/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLF;

public final class TiffProfileDLFGray
extends TiffProfileDLF {
    public TiffProfileDLFGray() {
        this._profileText = "DLF Benchmark for Faithful Digital Reproductions of Monographs and Serials: grayscale and white";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesCompression(tifd, new int[]{1, 5, 32773})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, new int[]{1})) {
            return false;
        }
        int[] bps = tifd.getNisoImageMetadata().getBitsPerSample();
        if (bps == null || bps[0] != 8) {
            return false;
        }
        return this.hasMinimumResolution(tifd, 300.0, 760.0);
    }
}

