/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public class TiffProfileDNGThumb
extends TiffProfile {
    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (tifd.getDNGVersion() == null) {
            return false;
        }
        if (tifd.getNewSubfileType() != 1L) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (tifd.getAsShotNeutral() != null && tifd.getAsShotWhiteXY() != null) {
            return false;
        }
        return tifd.getUniqueCameraModel() != null;
    }
}

