/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.iff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ChunkHeader {
    private ModuleBase _module;
    private RepInfo _repInfo;
    private long _size;
    private String _chunkID;

    public ChunkHeader(ModuleBase module, RepInfo info) {
        this._module = module;
        this._repInfo = info;
    }

    public boolean readHeader(DataInputStream dstrm) throws IOException {
        StringBuffer id = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int ch = ModuleBase.readUnsignedByte((DataInputStream)dstrm, (ModuleBase)this._module);
            if (ch < 32) {
                String hx = Integer.toHexString(ch);
                if (hx.length() < 2) {
                    hx = "0" + hx;
                }
                this._repInfo.setMessage((Message)new ErrorMessage("Invalid character in Chunk ID", "Character = 0x" + hx, this._module.getNByte()));
                this._repInfo.setWellFormed(false);
                return false;
            }
            id.append((char)ch);
        }
        this._chunkID = id.toString();
        this._size = ModuleBase.readUnsignedInt((DataInputStream)dstrm, (boolean)this._module.isBigEndian(), (ModuleBase)this._module);
        return true;
    }

    public void setID(String id) {
        this._chunkID = id;
    }

    public String getID() {
        return this._chunkID;
    }

    public void setSize(long size) {
        this._size = size;
    }

    public long getSize() {
        return this._size;
    }
}

