/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.CountedInputStream;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.InflaterInputStream;

public class BinaryFilterBox
extends JP2Box {
    private static final int[] gzipuuid = new int[]{236, 52, 11, 4, 116, 197, 17, 212, 167, 41, 135, 158, 163, 84, 143, 14};
    private DataInputStream boxStream;
    private JP2Box _realParent;

    public BinaryFilterBox(RandomAccessFile raf, JP2Box parent) {
        super(raf, parent);
        this._realParent = parent;
    }

    @Override
    public boolean readBox() throws IOException {
        byte[] uuidbuf = new byte[16];
        ModuleBase.readByteBuf((DataInputStream)this._dstrm, (byte[])uuidbuf, (ModuleBase)this._module);
        boolean isGzip = true;
        for (int i = 0; i < 16; ++i) {
            if (uuidbuf[i] == gzipuuid[i]) continue;
            isGzip = false;
        }
        this._module.addBinaryFilterProp(new Property("BinaryFilter", PropertyType.BYTE, PropertyArity.ARRAY, (Object)uuidbuf));
        if (isGzip) {
            this._repInfo.setMessage((Message)new InfoMessage("Binary Filter Box of type other than Gzip, contents not processed", this._module.getFilePos()));
        } else {
            int streamLimit = (int)(this._boxHeader.getLength() - 16L);
            this.boxStream = new DataInputStream(new InflaterInputStream((InputStream)new CountedInputStream((InputStream)this._dstrm, streamLimit)));
        }
        return true;
    }

    @Override
    public Object next() {
        BoxHeader hdr = new BoxHeader(this._module, this.boxStream);
        try {
            hdr.readHeader();
            JP2Box box = JP2Box.boxMaker(hdr.getType(), this._realParent);
            box.setModule(this._module);
            box.setRepInfo(this._repInfo);
            box.setRandomAccessFile(this._raf);
            box.setDataInputStream(this.boxStream);
            return box;
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataInputStream getBoxStream() {
        return this.boxStream;
    }

    @Override
    protected String getSelfPropName() {
        return "Binary Filter Box";
    }
}

