/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.Jpeg2000Module;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Marker;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Tile;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class ContCodestream {
    private Codestream _codestream;
    private long _length;
    private Jpeg2000Module _module;
    private DataInputStream _dstream;
    private List<Tile> _tiles;
    private long _tileLeft;
    private Tile _curTile;
    private boolean ppmSeen;
    private static final int SOC = 79;
    private static final int COD = 82;
    private static final int COC = 83;
    private static final int TLM = 85;
    private static final int PLM = 87;
    private static final int PLT = 88;
    private static final int QCD = 92;
    private static final int QCC = 93;
    private static final int RGN = 94;
    private static final int POC = 95;
    private static final int PPM = 96;
    private static final int PPT = 97;
    private static final int CRG = 99;
    private static final int COM = 100;
    private static final int SOT = 144;
    private static final int SOP = 145;
    private static final int EPH = 146;
    private static final int SOD = 147;
    private static final int EOC = 217;
    private static final int SIZ = 81;

    public ContCodestream(Jpeg2000Module module, DataInputStream dstream, long length) {
        this._module = module;
        this._dstream = dstream;
        this._length = length;
        this._tiles = new LinkedList<Tile>();
        this.ppmSeen = false;
    }

    public boolean readCodestream(Codestream cs, RepInfo info) throws IOException {
        String badStream = "Ill-formed codestream";
        this._codestream = cs;
        long lengthLeft = this._length;
        this._tileLeft = 0L;
        boolean socSeen = false;
        if (lengthLeft == 0L) {
            lengthLeft = Long.MAX_VALUE;
        }
        try {
            while (lengthLeft > 0L) {
                int ff = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
                if (ff != 255) {
                    info.setMessage((Message)new ErrorMessage("Ill-formed codestream"));
                    info.setWellFormed(false);
                    return false;
                }
                int marker = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
                if (marker == 79) {
                    socSeen = true;
                }
                MarkerSegment ms = MarkerSegment.markerSegmentMaker(marker);
                ms.setCodestream(cs);
                ms.setContCodestream(this);
                ms.setDataInputStream(this._dstream);
                ms.setRepInfo(info);
                ms.setModule(this._module);
                int markLen = ms.readMarkLen();
                if (!ms.process(markLen == 0 ? 0 : markLen - 2)) {
                    info.setMessage((Message)new ErrorMessage("Invalid marker segment"));
                    info.setWellFormed(false);
                    return false;
                }
                if (!(ms instanceof Marker)) {
                    lengthLeft -= (long)(markLen + 2);
                    if (this._tileLeft <= 0L) continue;
                    this._tileLeft -= (long)(markLen + 2);
                    continue;
                }
                lengthLeft -= 2L;
                if (this._tileLeft > 0L) {
                    this._tileLeft -= 2L;
                }
                if (marker == 147) {
                    this._module.skipBytes(this._dstream, (int)this._tileLeft, this._module);
                    lengthLeft -= this._tileLeft;
                    this._tileLeft = 0L;
                    continue;
                }
                if (marker != 217) continue;
                break;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (!socSeen) {
            info.setMessage((Message)new ErrorMessage("Ill-formed codestream"));
            info.setWellFormed(false);
            return false;
        }
        this._codestream.setTiles(this._tiles);
        return true;
    }

    public List<Tile> getTiles() {
        return this._tiles;
    }

    protected void setTileLeft(long tileLeft) {
        this._tileLeft = tileLeft;
    }

    protected Tile getTile(int idx) {
        while (this._tiles.size() <= idx) {
            this._tiles.add(new Tile());
        }
        return this._tiles.get(idx);
    }

    protected void setCurTile(Tile tile) {
        this._curTile = tile;
    }

    protected void setPPMSeen(boolean b) {
        this.ppmSeen = b;
    }

    protected Tile getCurTile() {
        return this._curTile;
    }

    protected boolean isPPMSeen() {
        return this.ppmSeen;
    }

    private static boolean isSegment(int marker) {
        return (marker < 48 || marker > 63) && marker != 79 && marker != 146 && marker != 147 && marker != 217;
    }
}

