/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.Ascii85FilterStream;
import edu.harvard.hul.ois.jhove.module.pdf.AsciiHexFilterStream;
import edu.harvard.hul.ois.jhove.module.pdf.Filter;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfFlateInputStream;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.RunLengthFilterStream;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class Stream
extends Token {
    private long _length = 0L;
    private long _offset = -1L;
    private int _bytesRead = 0;
    private Filter[] _filters = new Filter[0];
    private InputStream _inStream;
    private byte[] _sdata = null;

    public long getLength() {
        return this._length;
    }

    public void setLength(long length) {
        this._length = length;
    }

    public long getOffset() {
        return this._offset;
    }

    public void setOffset(long offset) {
        this._offset = offset;
    }

    public void setFilters(Filter[] filters) {
        this._filters = filters;
    }

    public void initRead(RandomAccessFile raf) throws IOException, PdfException {
        this._bytesRead = 0;
        raf.seek(this._offset);
        if (this._sdata == null) {
            int n;
            this._sdata = new byte[(int)this._length];
            int ln = 0;
            while ((long)ln < this._length && (n = raf.read(this._sdata, ln, (int)(this._length - (long)ln))) > 0) {
                ln += n;
            }
        }
        InputStream is = new ByteArrayInputStream(this._sdata);
        for (int i = 0; i < this._filters.length; ++i) {
            Filter filt = this._filters[i];
            String filtName = filt.getFilterName();
            if ("ASCIIHexDecode".equals(filtName) || "AHx".equals(filtName)) {
                is = new AsciiHexFilterStream(is);
                continue;
            }
            if ("ASCII85Decode".equals(filtName) || "A85".equals(filtName)) {
                is = new Ascii85FilterStream(is);
                continue;
            }
            if ("FlateDecode".equals(filtName) || "Fl".equals(filtName)) {
                is = new PdfFlateInputStream(is, filt.getDecodeParms());
                continue;
            }
            if (!"RunLengthDecode".equals(filtName) && !"RL".equals(filtName)) continue;
            is = new RunLengthFilterStream(is);
        }
        this._inStream = is;
    }

    public int read() throws IOException {
        int val = this._inStream.read();
        if (val >= 0) {
            ++this._bytesRead;
        }
        return val;
    }

    public int read(byte[] b) throws IOException {
        int n = this._inStream.read(b);
        if (n > 0) {
            this._bytesRead += n;
        }
        return n;
    }

    public long skipBytes(long n) throws IOException {
        long val = this._inStream.skip(n);
        this._bytesRead = (int)((long)this._bytesRead + val);
        return val;
    }

    public int readAsciiInt() throws IOException, PdfException {
        int val;
        block2: {
            boolean digitSeen = false;
            val = 0;
            while (true) {
                char c;
                if (Character.isDigit(c = (char)this.read())) {
                    digitSeen = true;
                    val = val * 10 + (c - 48);
                    continue;
                }
                if (digitSeen) break block2;
                if (!Character.isWhitespace(c)) break;
            }
            throw new PdfMalformedException("Malformed ASCII number in stream");
        }
        return val;
    }

    public boolean advanceTo(int offset) throws IOException {
        if (offset < this._bytesRead) {
            return false;
        }
        while (this._bytesRead < offset && this.skipBytes(offset - this._bytesRead) > 0L) {
        }
        return true;
    }
}

