/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfProfile;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.StructureTree;
import java.util.logging.Logger;

public final class TaggedProfile
extends PdfProfile {
    private Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove.module");

    public TaggedProfile(PdfModule module) {
        super(module);
        this._profileText = "Tagged PDF";
    }

    @Override
    public boolean satisfiesThisProfile() {
        try {
            PdfDictionary docCatDict = this._module.getCatalogDict();
            PdfDictionary markInfo = (PdfDictionary)this._module.resolveIndirectObject(docCatDict.get("MarkInfo"));
            if (markInfo == null) {
                return false;
            }
            PdfSimpleObject marked = (PdfSimpleObject)markInfo.get("Marked");
            if (!marked.isTrue()) {
                return false;
            }
            StructureTree stree = new StructureTree(this._module, this._raf, this._parser, true);
            if (!stree.isPresent() || !stree.isValid()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

