/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITCTP1
extends TiffProfileClassIT {
    public TiffProfileClassITCTP1() {
        this._profileText = "TIFF/IT-CT/P1 (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesNewSubfileType(tifd, 0L)) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (bps == null || bps.length != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (bps[i] == 8) continue;
            return false;
        }
        if (!this.satisfiesCompression(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, 5)) {
            return false;
        }
        if (!this.satisfiesOrientation(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, 4)) {
            return false;
        }
        if (!this.satisfiesPlanarConfiguration(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3})) {
            return false;
        }
        int inkSet = tifd.getInkSet();
        if (inkSet != 1) {
            return false;
        }
        int numInks = tifd.getNumberOfInks();
        if (numInks != 4) {
            return false;
        }
        if (!this.satisfiesDotRange(tifd, 0, 255)) {
            return false;
        }
        return tifd.getDocumentName() == null && niso.getScannerModelName() == null && tifd.getPageName() == null && niso.getHostComputer() == null && tifd.getSite() == null && tifd.getColorSequence() == null && tifd.getIT8Header() == null;
    }
}

