/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITLWP1
extends TiffProfileClassIT {
    public TiffProfileClassITLWP1() {
        this._profileText = "TIFF/IT-LW/P1 (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (tifd.getColorTable() == null) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (bps[0] != 8) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesNewSubfileType(tifd, 0L)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, 5)) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, 32896)) {
            return false;
        }
        int inkSet = tifd.getInkSet();
        if (inkSet != 1) {
            return false;
        }
        int bprl = tifd.getBitsPerRunLength();
        if (bprl != 8) {
            return false;
        }
        int bperl = tifd.getBitsPerExtendedRunLength();
        if (bperl != 16) {
            return false;
        }
        int numInks = tifd.getNumberOfInks();
        return numInks == 4 && numInks == niso.getSamplesPerPixel();
    }
}

