/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLF;

public final class TiffProfileDLFColor
extends TiffProfileDLF {
    public TiffProfileDLFColor() {
        this._profileText = "DLF Benchmark for Faithful Digital Reproductions of Monographs and Serials: color";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesCompression(tifd, new int[]{1, 5, 32773})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{2, 6})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, new int[]{3})) {
            return false;
        }
        int[] bps = tifd.getNisoImageMetadata().getBitsPerSample();
        for (int i = 0; i < bps.length; ++i) {
            if (bps[i] == 8) continue;
            return false;
        }
        return this.hasMinimumResolution(tifd, 300.0, 760.0);
    }
}

