/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.enums;

public enum FileDeliveryRule {
    OWNER(101, "objectCharacteristics", "owner"),
    FILE_EXTENSION(3, "generalFileCharacteristics", "fileExtension"),
    FILE_FORMATS(3, "generalFileCharacteristics", "formatLibraryId"),
    FILE_MIME(3, "generalFileCharacteristics", "fileMIMEType"),
    FILE_ENTITY_TYPES(3, "generalFileCharacteristics", "FileEntityType"),
    IS_IN_PERMANENT(3);

    private final int operator;
    private final String dnxSection;
    private final String dnxSectionKey;

    private FileDeliveryRule(int operator) {
        this.operator = operator;
        this.dnxSection = null;
        this.dnxSectionKey = null;
    }

    private FileDeliveryRule(int operator, String dnxSection, String dnxSectionKey) {
        this.operator = operator;
        this.dnxSection = dnxSection;
        this.dnxSectionKey = dnxSectionKey;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getDnxSection() {
        return this.dnxSection;
    }

    public String getDnxSectionKey() {
        return this.dnxSectionKey;
    }
}

