/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.matchUtils;

import java.util.Arrays;

public class Phrase {
    private String[] phraseArr;
    private Boolean[] foundPhrase;

    public Phrase(String phrase) {
        this.phraseArr = phrase.trim().split("\\s+");
        this.foundPhrase = new Boolean[this.phraseArr.length];
        Arrays.fill((Object[])this.foundPhrase, (Object)false);
    }

    public int length() {
        return this.phraseArr.length;
    }

    public String get(int i) {
        return this.phraseArr[i];
    }

    public void setAsFoundAt(int i) {
        this.foundPhrase[i] = true;
    }

    public Boolean foundAt(int i) {
        return this.foundPhrase[i];
    }

    public int lengthAt(int i) {
        return this.phraseArr[i].length();
    }

    public void markAsMatched(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.foundPhrase[i] = true;
        }
    }

    public String[] getUnMatchedPhrase() {
        String ret = "";
        for (int i = 0; i < this.phraseArr.length; ++i) {
            if (this.foundPhrase[i].booleanValue()) continue;
            ret = ret + this.phraseArr[i] + " ";
        }
        if (ret.equals("")) {
            return null;
        }
        return ret.trim().split("\\s+");
    }

    public String getMatchedString() {
        String ret = "";
        for (int i = 0; i < this.phraseArr.length; ++i) {
            if (!this.foundPhrase[i].booleanValue()) continue;
            ret = ret + this.phraseArr[i] + " ";
        }
        return ret;
    }
}

