/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.normalizers;

import com.exlibris.core.infra.common.normalizers.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NormalizerUtil {
    private static Map<String, Normalizer> normCache = new HashMap<String, Normalizer>();
    private static Map<String, List<String>> profileToNormalizers = new HashMap<String, List<String>>();

    public static synchronized void init(Map<String, List<String>> profileToNormalizers) {
        NormalizerUtil.profileToNormalizers = profileToNormalizers;
    }

    public static Normalizer getNormalizer(String nomalizerName) {
        Normalizer norm = NormalizerUtil.getFromCache(nomalizerName);
        if (norm == null && (norm = NormalizerUtil.getNewInstance(nomalizerName)) != null) {
            NormalizerUtil.putInCache(nomalizerName, norm);
        }
        return norm;
    }

    public static List<String> getNormalizers(String profileName) {
        List<String> normalizers = profileToNormalizers.get(profileName);
        if (normalizers != null) {
            return normalizers;
        }
        return new ArrayList<String>();
    }

    public static String normalizeWithNormalizers(List<String> normalizers, String content) {
        if (normalizers == null || content == null || content.length() == 0) {
            return content;
        }
        try {
            for (String normalizer : normalizers) {
                content = NormalizerUtil.getNormalizer(normalizer).normalize(content);
            }
            return content;
        }
        catch (Exception e) {
            return content;
        }
    }

    public static String normalizeWithProfileName(String profileName, String content) {
        List<String> normalizers = NormalizerUtil.getNormalizers(profileName);
        return NormalizerUtil.normalizeWithNormalizers(normalizers, content);
    }

    private static Normalizer getFromCache(String nomalizerName) {
        return normCache.get(nomalizerName);
    }

    private static void putInCache(String nomalizerName, Normalizer n) {
        normCache.put(nomalizerName, n);
    }

    private static Normalizer getNewInstance(String nomalizerName) {
        Normalizer n = null;
        try {
            n = (Normalizer)Class.forName(nomalizerName).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static List<String> getProfiles() {
        Set<String> s = profileToNormalizers.keySet();
        if (s == null) {
            return null;
        }
        Iterator<String> i = s.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }
}

