/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.sax;

import com.exlibris.core.infra.common.sax.UnEscapeSequenceXMLFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxBuilderDnx
extends DefaultHandler {
    private StringBuilder fileDnx;
    private StringBuilder repDnx;
    private StringBuilder ieDnx;
    private StringBuilder characters = new StringBuilder();
    private String filePid;
    private String repPid;
    private String iePid = null;
    private static final String INDENTATION_CHAR = " ";
    private static final int INDENTATION_DIFF = 2;
    private int currIndentation = -2;
    private static final String ID_ATTR = "id";
    private static final String AMD_TAG = "mets:amdSec";
    private static final String DNX = "dnx";
    private static final String SECTION_TAG = "section";
    private static final String SIGNIFICANT_PROPERTIES_VAL = "significantProperties";
    private static final String BITSTREAM_AMD_SUFFIX = "bitstream-amd";
    private static final String AMD_SUFFIX = "-amd";
    private static final String FILE_ID_PREFIX = "FL";
    private static final String REP_ID_PREFIX = "REP";
    private static final String FILE_SEC_TAG = "mets:fileSec";
    private static final String XML_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<dnx xmlns=\"http://www.exlibrisgroup.com/dps/dnx\">";
    private boolean currElementEmpty = false;
    private boolean hasSubElements = false;
    private boolean isUnderIeAmdSec = false;
    private boolean isUnderRepAmdSec = false;
    private boolean isUnderFileAmdSec = false;
    private boolean isUnderdnx;
    private boolean isUnderSignificantPropSec = false;
    private boolean isBitStreamID = false;
    private boolean isUnderFileFixity = false;
    private boolean addIeText = false;
    private boolean addRepText = false;
    private boolean addFileText = false;
    private boolean isUnderFileSec = false;
    private int fixityLocation = 0;
    private Map<String, String> dnxMap = new HashMap<String, String>();
    private Map<String, String> fileLocMap = new HashMap<String, String>();
    private Map<String, String> fixityMap = new HashMap<String, String>();

    public SaxBuilderDnx() {
        this.fileDnx = new StringBuilder(XML_START);
        this.repDnx = new StringBuilder(XML_START);
        this.ieDnx = new StringBuilder(XML_START);
        this.currIndentation += 2;
    }

    public Map<String, String> getDnxMap() {
        return this.dnxMap;
    }

    public String getIePid() {
        return this.iePid;
    }

    public String getDnx(String pid) {
        return this.dnxMap.get(pid);
    }

    public String getFileRepPid(String fPid) {
        int location = this.dnxMap.get(fPid).indexOf("REP_PID=");
        if (location != -1) {
            return this.dnxMap.get(fPid).substring(location).split(";")[0].substring(8);
        }
        return this.dnxMap.get(fPid).substring(this.dnxMap.get(fPid).indexOf("parentID")).split("<")[0].substring(10);
    }

    public String getCurrentFileLoc(String fPid) {
        return this.fileLocMap.get(fPid);
    }

    public String getFileFixity(String fPid) {
        return this.fixityMap.get(fPid);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.currElementEmpty = true;
        this.hasSubElements = false;
        this.addFileText = this.isUnderdnx && this.isUnderFileAmdSec && !this.isUnderSignificantPropSec && !this.isBitStreamID;
        this.addRepText = this.isUnderdnx && this.isUnderRepAmdSec;
        boolean bl = this.addIeText = this.isUnderdnx && this.isUnderIeAmdSec;
        if (this.addIeText) {
            this.addText(this.ieDnx, qName);
        }
        if (this.addRepText) {
            this.addText(this.repDnx, qName);
        }
        if (this.addFileText) {
            this.addText(this.fileDnx, qName);
        }
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (this.addFileText) {
                    this.fileDnx.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
                }
                if (this.addRepText) {
                    this.repDnx.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
                }
                if (this.addIeText) {
                    this.ieDnx.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
                }
                if (this.isUnderFileSec) {
                    if ("mets:file".equals(qName) && ID_ATTR.equalsIgnoreCase(attributes.getQName(i))) {
                        this.filePid = attributes.getValue(i);
                    }
                    if ("mets:FLocat".equals(qName) && "xlin:href".equals(attributes.getQName(i))) {
                        this.fileLocMap.put(this.filePid, attributes.getValue(i));
                    }
                }
                if (AMD_TAG.equals(qName) && ID_ATTR.equalsIgnoreCase(attributes.getQName(i))) {
                    if (attributes.getValue(i).startsWith("ie")) {
                        this.isUnderIeAmdSec = true;
                    } else if (attributes.getValue(i).endsWith(BITSTREAM_AMD_SUFFIX)) {
                        this.isBitStreamID = true;
                    } else if (attributes.getValue(i).startsWith(REP_ID_PREFIX)) {
                        this.isUnderRepAmdSec = true;
                        this.repPid = attributes.getValue(i).replace(AMD_SUFFIX, "");
                    } else if (attributes.getValue(i).startsWith(FILE_ID_PREFIX)) {
                        this.isUnderFileAmdSec = true;
                        this.filePid = attributes.getValue(i).replace(AMD_SUFFIX, "");
                    }
                } else if (DNX.equals(qName)) {
                    this.isUnderdnx = true;
                }
                if (this.isUnderFileFixity && (attributes.getValue(i).equals("fixityType") || attributes.getValue(i).equals("fixityValue"))) {
                    ++this.fixityLocation;
                }
                if (!SECTION_TAG.equals(qName) || !ID_ATTR.equalsIgnoreCase(attributes.getQName(i))) continue;
                if (attributes.getValue(i).equals(SIGNIFICANT_PROPERTIES_VAL)) {
                    this.isUnderSignificantPropSec = true;
                }
                if (!attributes.getValue(i).equals("fileFixity")) continue;
                this.isUnderFileFixity = true;
                this.fixityLocation = 0;
            }
        }
        if (this.addIeText) {
            this.ieDnx.append(">");
        }
        if (this.addRepText) {
            this.repDnx.append(">");
        }
        if (this.addFileText) {
            this.fileDnx.append(">");
        }
        if (FILE_SEC_TAG.equals(qName)) {
            this.isUnderFileSec = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        boolean tempCopySignificantSec = this.isUnderSignificantPropSec;
        boolean tempCopyIeSec = this.isUnderIeAmdSec;
        boolean tempCopyRepSec = this.isUnderRepAmdSec;
        boolean tempCopyFileSec = this.isUnderFileAmdSec;
        this.isUnderSignificantPropSec &= !SECTION_TAG.equals(qName);
        this.isBitStreamID &= !AMD_TAG.equals(qName);
        if (!this.shouldBeStripped()) {
            this.appendCurrentText();
            if (this.isUnderIeAmdSec && this.isUnderdnx && !DNX.equals(qName)) {
                this.endElement(this.ieDnx, qName);
            } else if (this.isUnderRepAmdSec && this.isUnderdnx && !DNX.equals(qName)) {
                this.endElement(this.repDnx, qName);
            } else if (this.isUnderFileAmdSec && this.isUnderdnx && !DNX.equals(qName)) {
                if (tempCopySignificantSec && SECTION_TAG.equals(qName)) {
                    this.currElementEmpty = true;
                }
                this.endElement(this.fileDnx, qName);
            } else if (this.isUnderFileSec && FILE_SEC_TAG.equals(qName)) {
                this.isUnderFileSec = false;
            }
            this.isUnderIeAmdSec &= !AMD_TAG.equals(qName);
            this.isUnderRepAmdSec &= !AMD_TAG.equals(qName);
            this.isUnderFileAmdSec &= !AMD_TAG.equals(qName);
            if (!this.isUnderRepAmdSec && tempCopyRepSec) {
                this.addValToMap(this.repPid, this.repDnx);
            }
            if (!this.isUnderFileAmdSec && tempCopyFileSec) {
                this.addValToMap(this.filePid, this.fileDnx);
            }
            if (!this.isUnderIeAmdSec && tempCopyIeSec) {
                this.addValToMap(this.iePid, this.ieDnx);
            }
            this.isUnderdnx &= !DNX.equals(qName);
        }
    }

    private void addText(StringBuilder stringToWrite, String qName) {
        this.appendCurrentText();
        this.currIndentation += 2;
        if (stringToWrite.toString().equals("")) {
            stringToWrite.append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation)).append('<' + qName);
        } else {
            stringToWrite.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation)).append('<' + qName);
        }
    }

    private void appendCurrentText() {
        if (this.addIeText) {
            this.ieDnx.append(this.characters.toString().trim());
        } else if (this.addRepText) {
            this.repDnx.append(this.characters.toString().trim());
        } else if (this.addFileText) {
            this.fileDnx.append(this.characters.toString().trim());
            if (this.fixityLocation == 1 && !this.characters.toString().trim().equals("")) {
                this.fixityMap.put(this.filePid + "fixityType", this.characters.toString().trim());
            }
            if (this.fixityLocation == 2 && !this.characters.toString().trim().equals("")) {
                this.fixityMap.put(this.filePid + "fixityValue", this.characters.toString().trim());
                this.isUnderFileFixity = false;
                ++this.fixityLocation;
            }
        }
        this.characters.setLength(0);
    }

    private void endElement(StringBuilder stringToWrite, String qName) {
        if (this.currElementEmpty) {
            stringToWrite.setLength(stringToWrite.length() - 1);
            stringToWrite.append("/>");
        } else {
            if (this.hasSubElements) {
                stringToWrite.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation));
            }
            stringToWrite.append("</" + qName + '>');
        }
        this.currIndentation -= 2;
        this.currElementEmpty = false;
        this.hasSubElements = true;
    }

    private void addValToMap(String key, StringBuilder value) {
        value.append("\n</dnx>");
        this.dnxMap.put(key, value.toString().trim());
        value.delete(0, value.length());
        value.append(XML_START);
        if (!key.contains("IE")) {
            key = "";
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.isUnderRepAmdSec && this.isUnderdnx || this.isUnderFileAmdSec && this.isUnderdnx || this.isUnderIeAmdSec && this.isUnderdnx) {
            this.characters.append(ch, start, length);
            if (this.characters.toString().trim().length() > 0) {
                this.currElementEmpty = false;
                if (this.characters.toString().contains("IE_PID=") && this.iePid == null) {
                    this.iePid = this.characters.toString().substring(this.characters.toString().indexOf("IE_PID=")).split(";")[0].substring(7);
                }
            }
        }
    }

    private boolean shouldBeStripped() {
        return this.isUnderFileAmdSec && this.isUnderSignificantPropSec;
    }

    public void parse(InputStream is) throws SAXException, IOException {
        try {
            UnEscapeSequenceXMLFilter xmlFilter = new UnEscapeSequenceXMLFilter(XMLReaderFactory.createXMLReader());
            xmlFilter.setContentHandler(this);
            xmlFilter.parse(new InputSource(is));
        }
        finally {
            is.close();
        }
    }
}

