/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.sax;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxStripperSignificantProperties
extends DefaultHandler {
    private StringBuilder strippedDocument = null;
    private StringBuilder strippedCharacters = new StringBuilder();
    private static final String ID_ATTR = "id";
    private static final String AMD_TAG = "mets:amdSec";
    private static final String SECTION_TAG = "section";
    private static final String SIGNIFICANT_PROPERTIES_VAL = "significantProperties";
    private static final String FILE_AMD_SUFFIX = "-amd";
    private static final String BITSTREAM_AMD_SUFFIX = "bitstream-amd";
    private static final String FILE_ID_PREFIX = "FL";
    private boolean isUnderFileAmdSec = false;
    private boolean isUnderBitStreamAmdSec = false;
    private boolean isUnderSignificantProperties = false;

    public SaxStripperSignificantProperties(int origXmlSize) {
        this.strippedDocument = new StringBuilder(origXmlSize / 5);
    }

    public String getStriped() {
        return this.strippedDocument.toString();
    }

    private void appendCurrentText() {
        this.strippedDocument.append(this.strippedCharacters.toString().trim());
        this.strippedCharacters.setLength(0);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.shouldBeStripped()) {
            boolean isBitStreamID = false;
            boolean isFileID = false;
            boolean isObjectCharacteristics = false;
            this.appendCurrentText();
            this.strippedDocument.append('<' + qName);
            if (attributes != null && attributes.getLength() > 0) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.strippedDocument.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
                    if (ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) && attributes.getValue(i) != null && attributes.getValue(i).startsWith(FILE_ID_PREFIX) && attributes.getValue(i).endsWith(BITSTREAM_AMD_SUFFIX)) {
                        isBitStreamID = true;
                        continue;
                    }
                    if (ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) && attributes.getValue(i) != null && attributes.getValue(i).startsWith(FILE_ID_PREFIX) && attributes.getValue(i).endsWith(FILE_AMD_SUFFIX)) {
                        isFileID = true;
                        continue;
                    }
                    if (!ID_ATTR.equalsIgnoreCase(attributes.getQName(i)) || !SIGNIFICANT_PROPERTIES_VAL.equals(attributes.getValue(i))) continue;
                    isObjectCharacteristics = true;
                }
            }
            this.strippedDocument.append(">");
            if (AMD_TAG.equals(qName) && isBitStreamID) {
                this.isUnderBitStreamAmdSec = true;
            } else if (AMD_TAG.equals(qName) && isFileID) {
                this.isUnderFileAmdSec = true;
            } else if (SECTION_TAG.equals(qName) && isObjectCharacteristics) {
                this.isUnderSignificantProperties = true;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.isUnderBitStreamAmdSec &= !AMD_TAG.equals(qName);
        this.isUnderFileAmdSec &= !AMD_TAG.equals(qName);
        this.isUnderSignificantProperties &= !SECTION_TAG.equals(qName);
        if (!this.shouldBeStripped()) {
            this.appendCurrentText();
            this.strippedDocument.append("</" + qName + '>');
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.shouldBeStripped()) {
            this.strippedCharacters.append(ch, start, length);
        }
    }

    private boolean shouldBeStripped() {
        return this.isUnderFileAmdSec && this.isUnderSignificantProperties || this.isUnderBitStreamAmdSec;
    }
}

