/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class JdbcConnectionUtil {
    private static ExLogger log = ExLogger.getExLogger(JdbcConnectionUtil.class);

    public static Connection getConnection(DataSource ds) {
        Connection connection = null;
        try {
            connection = ds.getConnection();
        }
        catch (Exception e) {
            log.error("Sql exception unable set connection " + e.getMessage(), new String[0]);
        }
        return connection;
    }

    public static void closeConnections(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            log.error("Cannot close ResultSet", e, new String[0]);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            log.error("Cannot close Statement", e, new String[0]);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error("Cannot close Connection", e, new String[0]);
        }
    }

    public static void rollbackConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                log.error("Cannot rollback Connection", e, new String[0]);
            }
        }
    }

    public static void commitConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                log.error("Cannot commit Connection", e, new String[0]);
            }
        }
    }
}

