/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class UnicodeToWordMapper {
    private static final ExLogger log = ExLogger.getExLogger(UnicodeToWordMapper.class);
    private static final String INPUT_MAPPING_FILE = "unicode_to_word_gen";
    private static final String COMMENT_SIGN = "!";
    private static final int CODE_START_POS = 0;
    private static final int CODE_END_POS = 4;
    private static final int NAME_START_POS = 5;
    private static final int NAME_END_POS = 9;
    private static UnicodeToWordMapper utwm;
    private Hashtable unicode2Word = new Hashtable();

    public static synchronized UnicodeToWordMapper getInstance() {
        if (utwm == null) {
            utwm = new UnicodeToWordMapper();
            utwm.load();
        }
        return utwm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        InputStream in;
        InputStreamReader isr;
        block6: {
            isr = null;
            in = null;
            log.info("Looking for unicode mapping file: unicode_to_word_gen ...");
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(INPUT_MAPPING_FILE);
            if (in != null) break block6;
            log.error("Unicode mapping file not found, unicode normalization will be unavailable." + in, new String[0]);
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(isr);
            return;
        }
        try {
            log.info("Unicode mapping file found.");
            isr = new InputStreamReader(in);
            BufferedReader bufferedReader = new BufferedReader(isr);
            String line = null;
            log.info("Start loading Unicode mapping file.");
            while ((line = bufferedReader.readLine()) != null) {
                if (line.length() <= 5 || line.trim().startsWith(COMMENT_SIGN)) continue;
                String code = line.substring(0, 4).trim();
                String name = line.substring(5, 9).trim();
                if (code.length() == 0 || name.length() == 0) continue;
                this.unicode2Word.put(code, name);
            }
            log.info("End loading Unicode mapping file.");
        }
        catch (Throwable e) {
            try {
                log.error("Failed to load unicode mapping file from unicode_to_word_gen: " + e.getMessage() + e.getLocalizedMessage() + e.getCause(), new String[0]);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                IOUtil.closeQuietly(isr);
                throw throwable;
            }
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(isr);
        }
        IOUtil.closeQuietly(in);
        IOUtil.closeQuietly(isr);
    }

    public Hashtable getUnicode2Word() {
        return this.unicode2Word;
    }

    public static void main(String[] args) {
        UnicodeToWordMapper.getInstance().getUnicode2Word();
        System.out.println(UnicodeToWordMapper.getInstance().getUnicode2Word().size());
    }
}

