/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.database.sqlcommand;

import com.exlibris.core.infra.svc.api.database.JDBCUtils;
import com.exlibris.core.infra.svc.api.database.sqlcommand.AbstractSQLCommand;
import com.exlibris.core.infra.svc.api.database.sqlcommand.SQLCommandBean;
import com.exlibris.core.infra.svc.api.database.sqlcommand.SQLCommandResults;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.xml.parsers.ParserConfigurationException;

public class TableSpaceDataFilesInformationSQLCommand
extends AbstractSQLCommand {
    private String query = "SELECT ddf.file_name name, \n       ROUND(NVL(ddf.bytes / 1024 / 1024, 0), 3) all_size, \n       ROUND(DECODE(NVL(u.bytes/1024/1024, 0), 0, NVL((ddf.bytes - NVL(s.bytes, 0))/1024/1024, 0), \n       NVL(u.bytes/1024/1024, 0)),3) used, \n       ROUND(DECODE((NVL(u.bytes, 0) / ddf.bytes * 100), 0, \n       NVL((ddf.bytes - NVL(s.bytes, 0)) / ddf.bytes * 100, 0), (NVL(u.bytes, 0) / ddf.bytes * 100)), 3) pct,\n       ddf.autoextensible ext\nFROM   sys.dba_data_files ddf, \n       (SELECT file_id, SUM(bytes) bytes \n        FROM sys.dba_free_space GROUP BY file_id) s, \n       (SELECT file_id, SUM(bytes) bytes \n        FROM sys.dba_undo_extents WHERE status <> 'EXPIRED' \n        GROUP BY file_id) u \nWHERE (ddf.file_id = s.file_id(+) \nand ddf.file_id=u.file_id(+) \nand ddf.tablespace_name like '";

    @Override
    public SQLCommandResults execute(SQLCommandBean commandBean) throws SQLException {
        String tsName = commandBean.getParams().getParam1();
        String orderBy = commandBean.getParams().getOrderBy();
        String filter = commandBean.getParams().getFilter();
        Statement stmt = commandBean.getConnection().createStatement();
        this.query = this.query + tsName + "') order by " + orderBy;
        ResultSet rs = stmt.executeQuery(this.query);
        SQLCommandResults results = new SQLCommandResults();
        try {
            results.setResults(JDBCUtils.toDocument(rs));
        }
        catch (ParserConfigurationException e) {
            results.setSuccess(false);
            results.setResults(null);
            return results;
        }
        results.setSuccess(true);
        return results;
    }
}

