/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.properties;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.model.properties.PropertiesConfiguration;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.properties.SolrIndexServices;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

public class SolrUtils {
    private static final String SOLR_ADMIN_USERS_PROPERTIES = "solr/prop/solr-admin-users.properties";
    private static final ExLogger log = ExLogger.getExLogger(SolrUtils.class, "RPS");
    private static Properties solrUsersFile = null;

    private static synchronized Properties getSolrUsersFile() throws URISyntaxException, IOException {
        if (solrUsersFile == null) {
            solrUsersFile = SolrUtils.loadProperties(SOLR_ADMIN_USERS_PROPERTIES);
        }
        return solrUsersFile;
    }

    public static String getSolrUrl(String idxProtocol, String idxServer, String idxProtocolPort, boolean includeProtocol) {
        String protocolPrefix = idxProtocol + "://";
        String slorUrl = includeProtocol ? protocolPrefix + idxServer + ":" + idxProtocolPort + "/solr/collection/" : idxServer + ":" + idxProtocolPort + "/solr/collection/";
        return slorUrl;
    }

    public static String getLocalhostSolrUrl(boolean includeProtocol) {
        String idxServer = GlobalProperties.getInstance().getProperty("idx.server");
        String idxProtocol = GlobalProperties.getInstance().getProperty("protocol.idx");
        String idxProtocolPort = GlobalProperties.getInstance().getProperty(idxProtocol + ".port");
        return SolrUtils.getSolrUrl(idxProtocol, idxServer, idxProtocolPort, includeProtocol);
    }

    public static String getSolrUpdateUrl() {
        String idxServer = GlobalProperties.getInstance().getProperty("idx.server");
        String idxProtocol = GlobalProperties.getInstance().getProperty("protocol.idx");
        String idxProtocolPort = GlobalProperties.getInstance().getProperty(idxProtocol + ".port");
        GeneralParameterManager generalParameterManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String commitWithin = generalParameterManager.getParameter("search", "solr_commit_within");
        return SolrUtils.getSolrUrl(idxProtocol, idxServer, idxProtocolPort, true) + "update?commitWithin=" + commitWithin;
    }

    public static String getShortFieldName(String fieldName) {
        ArrayList<String> fieldKeyParts = new ArrayList<String>(Arrays.asList(fieldName.split("\\.")));
        fieldKeyParts.remove(fieldKeyParts.size() - 1);
        fieldKeyParts.remove(fieldKeyParts.size() - 1);
        return StringUtils.join(fieldKeyParts, (String)".");
    }

    public static String getFullFieldName(String fieldName, PropertiesConfiguration properties) {
        StringBuffer fullFieldName = new StringBuffer(fieldName);
        switch (properties.getType()) {
            case DATE: {
                fullFieldName.append(".date");
                break;
            }
            case TEXT: {
                fullFieldName.append(".text");
                break;
            }
            case STRING: {
                fullFieldName.append(".string");
                break;
            }
            case NUMBER: {
                fullFieldName.append(".number");
                break;
            }
            case BOOLEAN: {
                fullFieldName.append(".boolean");
                break;
            }
            case NORM_STRING: {
                fullFieldName.append(".norm_string");
            }
        }
        if (properties.isRepeatable()) {
            fullFieldName.append(".multiple");
        } else {
            fullFieldName.append(".single");
        }
        return fullFieldName.toString();
    }

    public static String getFullFieldNameForStartsWith(String fieldName, PropertiesConfiguration properties) {
        StringBuffer fullFieldName = new StringBuffer(fieldName);
        fullFieldName.append(".norm_string");
        if (properties.isRepeatable()) {
            fullFieldName.append(".multiple");
        } else {
            fullFieldName.append(".single");
        }
        return fullFieldName.toString();
    }

    public static String getFullFieldNameForSort(String fieldName, PropertiesConfiguration properties) {
        StringBuffer fullFieldName = new StringBuffer(fieldName);
        if (PropertiesConfiguration.MetadataType.DC.equals((Object)properties.getMetadataType())) {
            fullFieldName.append(".norm_string.single");
            return fullFieldName.toString();
        }
        if ("IE.internalIdentifier.internalIdentifierType.PID".equals(fieldName) || "REP.internalIdentifier.internalIdentifierType.PID".equals(fieldName) || "FILE.internalIdentifier.internalIdentifierType.PID".equals(fieldName)) {
            fullFieldName.append(".number");
            fullFieldName.append(".single");
            return fullFieldName.toString();
        }
        return SolrUtils.getFullFieldName(fieldName, properties);
    }

    public static String getFullFieldName(String fieldName) {
        SolrIndexServices solrIndexServices = (SolrIndexServices)ServiceLocator.getInstance().lookUp(SolrIndexServices.class);
        PropertiesConfiguration propertiesConfiguration = solrIndexServices.getPropertyPerKey(fieldName);
        return SolrUtils.getFullFieldName(fieldName, propertiesConfiguration);
    }

    public static String getFullFieldNameForSort(String fieldName) {
        SolrIndexServices solrIndexServices = (SolrIndexServices)ServiceLocator.getInstance().lookUp(SolrIndexServices.class);
        PropertiesConfiguration propertiesConfiguration = solrIndexServices.getPropertyPerKey(fieldName);
        return SolrUtils.getFullFieldNameForSort(fieldName, propertiesConfiguration);
    }

    public static HttpSolrServer getSolrServer(String solrUrl) throws URISyntaxException, IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpSolrServer server = new HttpSolrServer(solrUrl, (HttpClient)httpClient);
        HttpClientUtil.setUseRetry((DefaultHttpClient)httpClient, (boolean)true);
        httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(), 0);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(SolrUtils.getSolrUsername(), SolrUtils.getSolrPassword());
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM), (Credentials)defaultcreds);
        return server;
    }

    public static String getSolrPassword() throws URISyntaxException, IOException {
        return SolrUtils.getSolrUsersFile().getProperty(SolrUtils.getSolrUsername()).split(",")[0];
    }

    public static String getSolrUsername() {
        return "slr";
    }

    public static Integer getMaxResults() {
        int maxResults = 100000;
        GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        try {
            maxResults = Integer.valueOf(gpm.getParameter("search", "search_max_results"));
        }
        catch (Exception e) {
            log.error("Failed to get maxResults from General Parameter, use default maxResults " + maxResults, e, new String[0]);
        }
        return maxResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String propFileName) throws URISyntaxException, IOException {
        Properties properties = new Properties();
        InputStream in = SolrUtils.class.getClassLoader().getResourceAsStream(propFileName);
        if (in != null) {
            try {
                properties.load(in);
                log.info("loaded application properties: /" + propFileName);
            }
            catch (IOException e) {
                log.error("Error reading solr-admin-users.properties file - " + e.getMessage(), new String[0]);
                e.printStackTrace();
            }
            finally {
                IOUtil.closeQuietly(in);
            }
        } else {
            log.error("Error reading solr-admin-users.properties file", new String[0]);
        }
        return properties;
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (creds == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authState.setAuthScheme((AuthScheme)new BasicScheme());
                authState.setCredentials(creds);
            }
        }
    }
}

