/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.quartz;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.logs.LogTable;
import com.exlibris.core.infra.model.quartz.JobDetails;
import com.exlibris.core.infra.model.quartz.QuartzJobConfig;
import com.exlibris.core.infra.svc.api.common.DBLogger;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.quartz.InfraQuartzJobsService;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public abstract class InfraStatefulJob
implements StatefulJob {
    public static final String QUARTZ_DB_LOGGER_GROUP = "quartz_jobs_logs";
    private ExLogger exLogger = ExLogger.getExLogger(this.getClass(), "JB");
    private DBLogger dbLogger = null;
    private boolean useDbLogger = false;
    private Map<LogTable.LogStatus, Boolean> updateJobLastRunDate = new HashMap<LogTable.LogStatus, Boolean>();

    public abstract void executeInternal(JobExecutionContext var1) throws JobExecutionException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute(JobExecutionContext context) throws JobExecutionException {
        LogTable.LogStatus logStatus;
        Calendar startTime = Calendar.getInstance();
        Long quartzJobConfigId = null;
        if (context != null) {
            quartzJobConfigId = (Long)context.getJobDetail().getJobDataMap().get((Object)"job_id");
        }
        if (quartzJobConfigId == null) {
            this.exLogger.info("Notice: This job is not scheduled from the " + InfraQuartzJobsService.class.getSimpleName() + ", and therefore not associated to " + QuartzJobConfig.class.getSimpleName() + " entity.");
        } else {
            this.dbLogger = new DBLogger(QUARTZ_DB_LOGGER_GROUP, String.valueOf(quartzJobConfigId), startTime);
        }
        try {
            this.initUpdateJobLastRunDate();
            this.executeInternal(context);
            if (quartzJobConfigId == null) return;
            logStatus = this.dbLogger.getLogStatus();
        }
        catch (JobExecutionException e) {
            try {
                this.exLogger.error("Error occurred while execute job." + (StringUtils.isNotBlank((String)e.getMessage()) ? "\n  Error: " + e.getMessage() : ""), new String[0]);
                throw e;
            }
            catch (Throwable throwable) {
                if (quartzJobConfigId == null) throw throwable;
                LogTable.LogStatus logStatus2 = this.dbLogger.getLogStatus();
                try {
                    if (this.updateJobLastRunDate.get((Object)logStatus2).booleanValue()) {
                        InfraQuartzJobsService infraQuartzJobsService = (InfraQuartzJobsService)ServiceLocator.getInstance().lookUp(InfraQuartzJobsService.class);
                        infraQuartzJobsService.updateJobLastRunDate(quartzJobConfigId, startTime.getTime());
                    }
                    if (!this.useDbLogger) throw throwable;
                    String msg = "Job completed " + (logStatus2 == LogTable.LogStatus.SUCCESS ? "Successfully" : (logStatus2 == LogTable.LogStatus.WARN ? "with Warnings" : (logStatus2 == LogTable.LogStatus.ERROR ? "with Errors" : logStatus2.name())));
                    this.dbLogger.info(msg);
                    this.dbLogger.save();
                    throw throwable;
                }
                catch (EntityNotFoundException e2) {
                    this.exLogger.error("The quartzJobConfig ID - " + quartzJobConfigId + " from the JobDataMap - does not exist in DB.", new String[0]);
                }
                throw throwable;
            }
        }
        try {
            if (this.updateJobLastRunDate.get((Object)logStatus).booleanValue()) {
                InfraQuartzJobsService infraQuartzJobsService = (InfraQuartzJobsService)ServiceLocator.getInstance().lookUp(InfraQuartzJobsService.class);
                infraQuartzJobsService.updateJobLastRunDate(quartzJobConfigId, startTime.getTime());
            }
            if (!this.useDbLogger) return;
            String msg = "Job completed " + (logStatus == LogTable.LogStatus.SUCCESS ? "Successfully" : (logStatus == LogTable.LogStatus.WARN ? "with Warnings" : (logStatus == LogTable.LogStatus.ERROR ? "with Errors" : logStatus.name())));
            this.dbLogger.info(msg);
            this.dbLogger.save();
            return;
        }
        catch (EntityNotFoundException e) {
            this.exLogger.error("The quartzJobConfig ID - " + quartzJobConfigId + " from the JobDataMap - does not exist in DB.", new String[0]);
            return;
        }
    }

    protected void setDbLoggerOn() {
        if (this.dbLogger == null) {
            this.exLogger.error("Try to set DbLoggerOn for job but dbLogger is null.", new String[0]);
        } else {
            this.useDbLogger = true;
        }
    }

    protected void setDbLoggerOff() {
        this.useDbLogger = false;
    }

    protected void writeLogInfo(String message) {
        this.exLogger.info(message);
        if (this.useDbLogger) {
            this.dbLogger.info(message);
        }
    }

    protected void writeLogWarning(String message) {
        this.exLogger.warn((Object)message, new String[0]);
        if (this.useDbLogger) {
            this.dbLogger.warn(message);
        }
    }

    protected void writeLogError(String message) {
        this.exLogger.error(message, new String[0]);
        if (this.useDbLogger) {
            this.dbLogger.error(message);
        }
    }

    protected void writeLogError(String message, Throwable e) {
        this.exLogger.error(message, e, new String[0]);
        if (this.useDbLogger) {
            this.dbLogger.error(message);
        }
    }

    protected void writeLogDebug(String message) {
        this.exLogger.debug((Object)message, new String[0]);
    }

    protected void disableJobLastRunDate(LogTable.LogStatus ... logStatuses) {
        for (LogTable.LogStatus logStatus : logStatuses) {
            this.updateJobLastRunDate.put(logStatus, false);
        }
    }

    protected void writeToServerLogError(String messageLog, Exception e) {
        this.exLogger.error(messageLog, e, new String[0]);
    }

    private void initUpdateJobLastRunDate() {
        for (LogTable.LogStatus logStatus : LogTable.LogStatus.values()) {
            this.updateJobLastRunDate.put(logStatus, true);
        }
    }

    protected void markDirectory(File subDirectory, DirectoryStatus status) throws IOException {
        String directoryPath = subDirectory.getPath();
        File doneFile = new File(FilenameUtils.concat((String)directoryPath, (String)DirectoryStatus.DONE.name()));
        File errorFile = new File(FilenameUtils.concat((String)directoryPath, (String)DirectoryStatus.ERROR.name()));
        File lockFile = new File(FilenameUtils.concat((String)directoryPath, (String)DirectoryStatus.LOCKED.name()));
        errorFile.delete();
        lockFile.delete();
        doneFile.delete();
        switch (status) {
            case DONE: {
                doneFile.createNewFile();
                break;
            }
            case LOCKED: {
                lockFile.createNewFile();
                break;
            }
            case ERROR: {
                errorFile.createNewFile();
            }
        }
    }

    protected boolean isReady(File directory) {
        if (!directory.isDirectory()) {
            return false;
        }
        for (DirectoryStatus status : DirectoryStatus.values()) {
            File checkFile = new File(FilenameUtils.concat((String)directory.getPath(), (String)status.name()));
            if (!checkFile.exists()) continue;
            String message = "'" + directory.getName() + "' is marked as " + StringUtils.capitalize((String)status.name().toLowerCase());
            if (DirectoryStatus.ERROR.equals((Object)status)) {
                this.writeLogError(message);
            } else {
                this.writeLogInfo(message);
            }
            return false;
        }
        return true;
    }

    protected void addJobDetails(JobDetails jobDetails) {
        this.dbLogger.addToJobDetailsList(jobDetails);
    }

    protected String getJobId() {
        return this.dbLogger.getSource();
    }

    public static enum DirectoryStatus {
        DONE,
        LOCKED,
        ERROR;

    }
}

