/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.svc.api.security.SimplePrincipal;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SimpleGroup
extends SimplePrincipal
implements Group,
Serializable {
    private static final long serialVersionUID = -7944344069052055265L;
    private Set<Principal> members = new HashSet<Principal>();

    public SimpleGroup(String groupName) {
        super(groupName);
    }

    public SimpleGroup(String groupName, String memberName) {
        super(groupName);
        this.members.add(new SimplePrincipal(memberName));
    }

    public SimpleGroup(String groupName, Principal member) {
        super(groupName);
        this.members.add(member);
    }

    public boolean isMember(Principal p) {
        return this.members.contains(p);
    }

    public boolean addMember(Principal p) {
        return this.members.add(p);
    }

    public Enumeration<? extends Principal> members() {
        final Iterator<Principal> it = this.members.iterator();
        return new Enumeration<Principal>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public Principal nextElement() {
                return (Principal)it.next();
            }
        };
    }

    public boolean removeMember(Principal p) {
        return this.members.remove(p);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleGroup)) {
            return false;
        }
        SimpleGroup other = (SimpleGroup)obj;
        return this.getName().equals(other.getName()) && this.members.equals(other.members);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + 37 * this.members.hashCode();
    }
}

