/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.utils;

import com.exlibris.core.infra.svc.api.config.InfraConfigurationManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;

public class LanguageUtil {
    public static final String LOCALE = "locale";
    public static final String DEFAULT_LOCALE = "en";
    public static final String CON_LNG = "&con_lng=";
    public static final String INT_LNG = "&int_lng=";

    public static boolean isLTR(HttpServletRequest request) {
        return true;
    }

    public static final String getUserLocaleFromRequest(HttpServletRequest request) {
        String locale = request.getParameter(LOCALE);
        if (!(locale != null && locale.trim().length() != 0 || (locale = (String)request.getSession().getAttribute(LOCALE)) != null && locale.trim().length() != 0)) {
            String conLng = request.getParameter("con_lng");
            if (conLng == null || conLng.trim().length() == 0) {
                conLng = (String)request.getSession().getAttribute("con_lng");
            }
            if (conLng != null) {
                try {
                    locale = InfraConfigurationManager.getInstance().getLocale(conLng);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        return locale;
    }

    public static final void overwriteConfigIfNeeded(HttpServletRequest request) {
        String locale = LanguageUtil.getUserLocaleFromRequest(request);
        if (!(locale != null && locale.trim().length() != 0 || (locale = request.getLocale().toString().trim()) != null && locale.trim().length() != 0)) {
            locale = DEFAULT_LOCALE;
        }
        if (locale != null && locale.trim().length() == 2) {
            request.getSession().setAttribute(LOCALE, (Object)locale);
            Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
        }
    }

    public static final String ltr2Rtl(String ltrString) {
        if (ltrString == null || ltrString.trim().length() == 0) {
            return ltrString;
        }
        String rtlString = ltrString;
        char ltrStringPostfix = ltrString.charAt(ltrString.length() - 1);
        if (!LanguageUtil.isAlpha(ltrStringPostfix)) {
            ltrString = ltrString.substring(0, ltrString.length() - 1);
            String ltrStringPart1 = "";
            String ltrStringPart2 = "";
            boolean foundAlphaChar = false;
            int pivot = 0;
            while (pivot < ltrString.length() && !foundAlphaChar) {
                char currChar = ltrString.charAt(pivot);
                if (!LanguageUtil.isAlpha(currChar)) {
                    ++pivot;
                    continue;
                }
                foundAlphaChar = true;
            }
            if (pivot < ltrString.length()) {
                ltrStringPart1 = ltrString.substring(0, pivot);
                ltrStringPart2 = ltrString.substring(pivot);
            } else {
                ltrStringPart1 = ltrString;
            }
            rtlString = ltrStringPostfix == ')' ? ltrStringPart1 + "(" + ltrStringPart2 : (ltrStringPostfix == '(' ? ltrStringPart1 + ")" + ltrStringPart2 : ltrStringPart1 + ltrStringPostfix + ltrStringPart2);
        }
        return rtlString;
    }

    public static final boolean isAlpha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    public static final boolean isHebrew(String st) {
        boolean ind = false;
        if (st != null) {
            for (int i = 0; i < st.length(); ++i) {
                Character.UnicodeBlock cu = Character.UnicodeBlock.of(st.charAt(i));
                if (cu != Character.UnicodeBlock.HEBREW) continue;
                ind = true;
            }
        }
        return ind;
    }
}

